CREATE PROCEDURE UpdateAlgorithm()
BEGIN
    -- 1. Объявляем переменные
    DECLARE v_id VARCHAR(36);
    DECLARE v_algorithm TEXT;
    DECLARE v_varname TEXT;
    DECLARE v_escaped_varname TEXT;
    DECLARE v_constantname TEXT;

    -- 2. Объявляем флаг завершения
    DECLARE done INT DEFAULT 0;

    -- 3. Объявляем курсоры
    DECLARE cur_params CURSOR FOR
SELECT Id, Algorithm FROM OTParameters;

DECLARE cur_vars CURSOR FOR
SELECT Name, CONCAT('%', Name, '%') FROM OTAlgorithmParameters WHERE ParameterId = v_id;

DECLARE cur_consts CURSOR FOR
SELECT Name FROM OTAlgorithmConstants WHERE ParameterId = v_id;

-- 4. Один обработчик NOT FOUND для всех курсоров
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;

    -- 5. Открываем курсор параметров
OPEN cur_params;
SET done = 0;
    
    read_params: LOOP
        FETCH cur_params INTO v_id, v_algorithm;
        IF done = 1 THEN LEAVE read_params; END IF;  -- Выход, когда все параметры обработаны

        -- Обрабатываем переменные
OPEN cur_vars;
SET done = 0;
        read_vars: LOOP
            FETCH cur_vars INTO v_varname, v_escaped_varname;
            IF done = 1 THEN LEAVE read_vars; END IF;
            SET v_algorithm = REPLACE(v_algorithm, v_varname, v_escaped_varname);
END LOOP;
CLOSE cur_vars;

-- Обрабатываем константы
OPEN cur_consts;
SET done = 0;
        read_consts: LOOP
            FETCH cur_consts INTO v_constantname;
            IF done = 1 THEN LEAVE read_consts; END IF;
            SET v_algorithm = REPLACE(v_algorithm, v_constantname, CONCAT('%', v_constantname, '%'));
END LOOP;
CLOSE cur_consts;

-- Обновляем запись в OTParameters
UPDATE OTParameters SET Algorithm = v_algorithm WHERE Id = v_id;

-- Сбрасываем флаг `done`, чтобы перейти к следующему параметру
SET done = 0;
END LOOP;

CLOSE cur_params;
END;


CALL UpdateAlgorithm();
DROP PROCEDURE UpdateAlgorithm;