UPDATE [OTParameters]
SET
    [CalculationEndDate] = (
    SELECT CASE
    WHEN [Value] IS NULL OR [Value] = 'DEFAULT_VALUE' THEN NULL
    ELSE TRY_CONVERT(DATETIME, [Value])
    END
    FROM [ServerSettings]
    WHERE [Name] = 'OperationTime:LastCalculationTime'
    ),
    [CalculationStartDate] = (
    CASE
    WHEN EXISTS (
    SELECT 1 FROM [OTRecords]
    JOIN [OTDevices] ON [OTDevices].[Id] = [OTRecords].[DeviceId]
    WHERE [OTDevices].[ParameterId] = [OTParameters].[Id]
    )
    THEN (
    SELECT MIN([OTRecords].[TimeStamp])
    FROM [OTRecords]
    JOIN [OTDevices] ON [OTDevices].[Id] = [OTRecords].[DeviceId]
    WHERE [OTDevices].[ParameterId] = [OTParameters].[Id]
    )
    ELSE [CalculationStartDate]
    END
    )
WHERE EXISTS (
    SELECT 1 FROM [ServerSettings] WHERE [Name] = 'OperationTime:LastCalculationTime'
    );