CREATE TABLE "td"."UserAuthenticationTypes" (
    "Id" UUID PRIMARY KEY,
    "UserId" UUID NOT NULL,
    "Login" VARCHAR(255) NOT NULL,
    "Password" VARCHAR(255),
    "Type" INTEGER NOT NULL,
    "IsEnabled" BOOLEAN NOT NULL DEFAULT TRUE,
    CONSTRAINT "FK_UserAuthenticationTypes_Users_UserId" FOREIGN KEY ("UserId") REFERENCES "td"."Users"("Id") ON DELETE CASCADE
);

CREATE UNIQUE INDEX "IX_UserAuthenticationTypes_Login_Type" ON td."UserAuthenticationTypes" ("Login", "Type");

INSERT INTO "td"."UserAuthenticationTypes" ("Id", "UserId", "Login", "Password", "Type", "IsEnabled")
SELECT gen_random_uuid(), "Id", "Login", "Password", "AuthenticationType", TRUE
FROM "td"."Users";

ALTER TABLE "td"."Users" DROP COLUMN "Login";
ALTER TABLE "td"."Users" DROP COLUMN "Password";
ALTER TABLE "td"."Users" DROP COLUMN "AuthenticationType";
ALTER TABLE "td"."Users" DROP COLUMN "SigningAuthority";
