CREATE TEMP TABLE TempParams AS
SELECT
    ParameterId AS ParamId,
    Name AS VarName,
    '%' || Name || '%' AS EscapedVarName
FROM OTAlgorithmParameters

UNION ALL

SELECT
    ParameterId AS ParamId,
    Name AS VarName,
    '%' || Name || '%' AS EscapedVarName
FROM OTAlgorithmConstants

ORDER BY ParamId, VarName;

UPDATE OTParameters
SET Algorithm = (
    SELECT NewAlgorithm
    FROM (
             WITH RECURSIVE ReplaceVars(Id, NewAlgorithm, VarName) AS (
                 SELECT p.Id, p.Algorithm, t.VarName
                 FROM OTParameters p
                          JOIN TempParams t ON p.Id = t.ParamId
                 WHERE t.VarName = (SELECT Min(VarName) FROM TempParams WHERE ParamId = p.Id)

                 UNION ALL

                 SELECT r.Id,
                        REPLACE(r.NewAlgorithm, r.VarName, (SELECT EscapedVarName FROM TempParams WHERE VarName = r.VarName)),
                        (SELECT VarName FROM TempParams WHERE ParamId = r.Id AND VarName > r.VarName ORDER BY VarName LIMIT 1)
             FROM ReplaceVars r
             WHERE r.VarName IS NOT NULL
         )
SELECT Id, NewAlgorithm FROM ReplaceVars
WHERE VarName IS NULL
    ) AS TempResult
WHERE TempResult.Id = OTParameters.Id
    );

Drop table TempParams;