// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Интеграция с ТехноДок

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

#uses "Technodoc/Core/technodocAuthorization"
#uses "CtrlHTTP"
#uses "CtrlXmlRpc"
#uses "xmlrpcHandlerCommon"

#uses "Technodoc/Common/technodocGetTagTree"
#uses "Technodoc/Common/technodocGetValue"
#uses "Technodoc/Common/technodocMisc"
#uses "Technodoc/Common/technodocAlarms"

#uses "Technodoc/Core/technodocHttpCommandsHandler"
#uses "Technodoc/Core/technodocServerSettings"

#uses "Technodoc/SwitchoverForms/technodocExecuteCommands"

//--------------------------------------------------------------------------------
// Variables and Constants

//--------------------------------------------------------------------------------
// Константы для работы XML RPC сервера для связи с ТехноДок

// Порт для XMLRPC сервера для работы по протоколу HTTP (в случае указания 0 данный протокол будет отключен)
const int TECHNODOC_XMLRPC_HTTP_PORT = 8242;

// Порт для XMLRPC сервера для работы по протоколу HTTPS (в случае указания 0 данный протокол будет отключен)
const int TECHNODOC_XMLRPC_HTTPS_PORT = 0;

// Использовать XML-RPC для взаимодействия ТехноДок
const bool USING_XMLRPC_TO_HANDLE_REQUESTS = true;

// Использовать API ТехноДока для взаимодействия через веб-запросы
const bool USING_TECHNODOC_API_TO_HANDLE_REQUESTS = false;

// Наименование  заголовка с версией API
const string TECHNODOC_VERSION_HEADER_NAME = "Technodoc-Version";

//--------------------------------------------------------------------------------

/** Запускает Http server для обмена данными с ТехноДоком по протоколу XML-RPCs
*/
main()
{
    //setQueryRDBDirect(TRUE);
  if(USING_XMLRPC_TO_HANDLE_REQUESTS)
  {
    startHttpServer();
  }

  if(USING_TECHNODOC_API_TO_HANDLE_REQUESTS)
  {
    startThread("startHandlingCommands");
  }
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

/** Запустить HTTP сервер
*/
private void startHttpServer()
{
    DebugTN("Запускаем XMLRPC-сервер...");

    //Start the HTTP Server
    if (httpServer(false, TECHNODOC_XMLRPC_HTTP_PORT, TECHNODOC_XMLRPC_HTTPS_PORT) < 0)
    {
        DebugTN("ERROR: HTTP-server can't start. --- Check license");
        return;
    }

    //Start the XmlRpc Handler
    httpConnect("xmlRpcHandler", "/RPC2");
    httpSetMaxContentLength(9999999);

    string statusMessage = (TECHNODOC_XMLRPC_HTTPS_PORT == 0)
                           ? ("XMLRPC-сервер запущен на порту " + TECHNODOC_XMLRPC_HTTP_PORT)
                           : ("XMLRPC-сервер запущен на портах " + TECHNODOC_XMLRPC_HTTP_PORT + " и " + TECHNODOC_XMLRPC_HTTPS_PORT);

    DebugTN(statusMessage);

}


/** Обработчик запроса от XMLRPC клиента
  @param content Данные запроса
  @param user
  @param ip
  @param ds1
  @param ds2
  @param connIdx
  @return Ответ в виде XML
*/
private mixed xmlRpcHandler(const mixed content, string user, string ip, dyn_string ds1, dyn_string ds2, int connIdx)
{
    string sMethod;
    dyn_mixed daArgs;
    string sResponse;
    mixed result;
    bool isError = false;

    xmlrpcDecodeRequest(content, sMethod, daArgs);
    //DebugTN("REQUEST >> " + sMethod);

    string technodocVersionValue = httpGetHeader(connIdx, TECHNODOC_VERSION_HEADER_NAME);

    if(technodocVersionValue != TECHNODOC_VERSION)
    {
      string errorMessage = "Несоответсвие версии сервера \"" + TECHNODOC_VERSION + "\" и клиента \"" + technodocVersionValue + "\". Пожайлуста обратитесь к администратору и актуализируйте скрипты.";
      dyn_errClass err = xmlRpcMakeError(PRIO_SEVERE, ERR_CONTROL, ERR_PARAMETER, errorMessage);
      throwError(err);
      return makeDynString(xmlrpcReturnFault(err), "Content-Type: text/xml");
    }

    switch (strtolower(sMethod))
    {
        /*
            Get value functions
         */
        case "get":
            result = getByFunctionName(daArgs[1], daArgs[2], daArgs[3], daArgs[4]);
            break;

        case "getdatapointvaluesonperiod":
            result = getDatapointValuesOnPeriod(daArgs[1], daArgs[2], daArgs[3]);
            break;

        case "getuserbitvalueontime":
            result = getUserbitValueOnTime(daArgs[1], daArgs[2], daArgs[3]);
            break;

        case "getalarms":
            result = getAlarms(daArgs[1], daArgs[2]);
            break;

        case "getalarmsonperiod":
            result = getAlarmsOnPeriod(daArgs[1], daArgs[2], daArgs[3]);
            break;

        /*
            Misc functions
         */
        case "echo":
            result = echo(daArgs[1]);
            break;

        case "query":
          result = query(daArgs[1]);
          break;

        case "getdescription":
          result = getDatapointDescription(daArgs[1]);
          break;

        case "getunit"  :
          result = getDatapointUnit(daArgs[1]);
          break;

        case "getformat"  :
          result = getDatapointFormat(daArgs[1]);
          break;

        case "evalstring":
          result = evaluateCode(daArgs[1]);
          break;

        case "checkdp":
          result = checkDp(daArgs[1]);
          break;

        case "getcatstr":
          result = getCatalogMessageEntry(daArgs[1], daArgs[2], daArgs[3]);
          break;

        /*
          GetTagTree function
        */
        case "gettagtree":
          result = getTagTree();
          break;

        case "getcnsnodes":
          result = getCnsNodes(daArgs[1]);
          result = base64Encode(jsonEncode(result));
          break;

        /*
          Execute commands functions
        */
        case "executecommands":
          result = executeCommands(daArgs[1]);
          result = jsonEncode(result);
          break;

		      /*
          Authorization functions
        */
        case "authenticateuser":
          result = checkPassword(getUserId(daArgs[1]), daArgs[2]);
          break;

        case "getuserroles":
          result = getUserRoles(daArgs[1]);
          break;

        /*
            Default: method not found
         */
        default:
            sResponse = xmlrpcReturnFault(1, "Method not found: " + sMethod);
            isError = true;
            exit;
    }

    if (!isError)
        sResponse = xmlrpcReturnSuccess(result);

    //DebugTN("RESPONSE >> " + sResponse);

    return makeDynString(sResponse, "Content-Type: text/xml");
}
