angular
    .module('kamhpp')
    .controller('CimModelDiagramCtrl', function ($rootScope, $scope, $http, clientSettings, notificationService, language) {
    var initUmlDiagram = function () {
        SVGElement.prototype.getTransformToElement =
            SVGElement.prototype.getTransformToElement ||
                function (elem) {
                    return elem.getScreenCTM().inverse().multiply(this.getScreenCTM());
                };
        $scope.uml = joint.shapes.uml;
        $scope.graph = new joint.dia.Graph();
        $scope.paperScroller = new joint.ui.PaperScroller();
        $scope.paper = new joint.dia.Paper({
            el: $scope.paperScroller.el,
            gridsize: 1,
            model: $scope.graph,
        });
        $scope.paperScroller.options.paper = $scope.paper;
        $('#paper').append($scope.paperScroller.render().el);
        $scope.paperScroller.$el.css({
            height: 600,
        });
        $scope.paper.on('blank:pointerdown', $scope.paperScroller.startPanning);
    };
    var resizeUmlDiagram = function () {
        var minWidth = $scope.paperScroller.$el.width() - 32;
        var minHeight = $scope.paperScroller.$el.height() - 32;
        var svgEl = $('#paper').find('svg');
        var gEl = svgEl.find('g').first()[0];
        var bBox = gEl.getBBox();
        var offsetCount = 2;
        var width = offsetCount * bBox.x + bBox.width;
        var height = offsetCount * bBox.y + bBox.height;
        svgEl.width(minWidth > width ? minWidth : width);
        svgEl.height(minHeight > height ? minHeight : height);
    };
    $scope.zoomIn = function () {
        $scope.paperScroller.zoom(3 / 2);
        resizeUmlDiagram();
    };
    $scope.zoomOut = function () {
        $scope.paperScroller.zoom(2 / 3);
        resizeUmlDiagram();
    };
    var refreshUmlDiagram = function () {
        var attributeRowHeight = 13;
        var classHeaderHeight = 50;
        var diagrammClasses = [];
        var diagrammRelations = [];
        var classItemToDiagramItem = [];
        _.forEach($scope.classes, function (cls) {
            var attributes = parseAttributes(cls.Attributes);
            var classWidth = getClassWidth(cls.Name, attributes);
            var diagrammItem = new $scope.uml.Class({
                size: {
                    width: classWidth,
                    height: classHeaderHeight + attributeRowHeight * cls.Attributes.length,
                },
                name: cls.Name,
                attributes: attributes,
            });
            diagrammClasses.push(diagrammItem);
            classItemToDiagramItem.push({ classItem: cls, diagrammItem: diagrammItem });
        });
        if ($scope.showRelations) {
            _.each($scope.relations, function (r) {
                var srcDiagrammClass = _.find(classItemToDiagramItem, function (arg) {
                    return arg.classItem.Id == r.SourceId;
                }).diagrammItem;
                var dstDiagrammClass = _.find(classItemToDiagramItem, function (arg) {
                    return arg.classItem.Id == r.TargetId;
                }).diagrammItem;
                var rel;
                switch (r.RelationType) {
                    case language.getElementValue('cimModelRelationTypeSuccessionHdr'):
                        rel = new $scope.uml.Generalization({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                    case language.getElementValue('cimModelRelationTypeAssociationHdr'):
                        rel = new $scope.uml.Association({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                    case language.getElementValue('cimModelRelationTypeAggregationHdr'):
                        rel = new $scope.uml.Aggregation({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                    case language.getElementValue('cimModelRelationTypeGeneralizationHdr'):
                        rel = new $scope.uml.Generalization({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                    case language.getElementValue('cimModelRelationTypeCompositionHdr'):
                        rel = new $scope.uml.Composition({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                    default:
                        rel = new $scope.uml.Association({
                            source: { id: srcDiagrammClass.id },
                            target: { id: dstDiagrammClass.id },
                            labels: $scope.showLabels
                                ? [
                                    {
                                        position: 0.5,
                                        attrs: {
                                            text: {
                                                text: r.Label || '',
                                                background: 'transparent',
                                                'font-size': 12,
                                            },
                                        },
                                    },
                                ]
                                : [],
                            connector: { name: 'smooth' },
                        });
                        break;
                }
                diagrammRelations.push(rel);
            });
        }
        var cells = diagrammClasses.concat(diagrammRelations);
        $scope.graph.resetCells(cells);
        joint.layout.DirectedGraph.layout($scope.graph, {
            setLinkVertices: false,
        });
        resizeUmlDiagram();
    };
    $rootScope.refreshUmlDiagram = refreshUmlDiagram;
    var parseAttributes = function (attrs) {
        var baseAttrs = [];
        var clsAttrs = _.map(attrs, function (arg) {
            return arg.Name + ':' + arg.DataType;
        });
        return baseAttrs.concat(clsAttrs);
    };
    var getClassWidth = function (name, attributes) {
        var arr = attributes;
        arr.push(name);
        var max = _.max(arr, function (e) {
            return e.length;
        });
        if (max == name) {
            return max.length * 7.4 + 20;
        }
        else {
            return max.length * 6.2;
        }
    };
    $scope.loadCimModel = function () {
        $http.get(clientSettings.getServerInstance() + '/CimModel/GetCimModel').then(function (response) {
            $scope.classes = response.data.Classes;
            $scope.relations = response.data.Relations;
            refreshUmlDiagram();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.showRelations = true;
    $scope.firstShowRelations = true;
    var unregistrationShowRelationsWatchFunc = $scope.$watch('showRelations', function () {
        if (!$scope.firstShowRelations) {
            refreshUmlDiagram();
        }
        $scope.firstShowRelations = false;
    });
    $scope.showLabels = false;
    $scope.firstShowLabels = true;
    var unregistrationShowLabelsWatchFunc = $scope.$watch('showLabels', function () {
        if (!$scope.firstShowLabels) {
            refreshUmlDiagram();
        }
        $scope.firstShowLabels = false;
    });
    var getImageDataURL = function () {
        var svg = $scope.paper.toSVG();
        canvg('canvas', svg);
        return canvas.toDataURL('image/png');
    };
    $scope.loadImage = function () {
        var link = document.createElement('a');
        link.download = language.getElementValue('cimModelClassUmlDiagramHdr');
        link.href = getImageDataURL();
        link.click();
    };
    $scope.printImage = function () {
        var win = window.open();
        win.document.write('<img src="' + getImageDataURL() + '">');
        win.print();
        win.close();
    };
    var unregistrationDestroyOnFunc = $scope.$on('$destroy', function () {
        $rootScope.refreshUmlDiagram = undefined;
        unregistrationShowLabelsWatchFunc();
        unregistrationShowRelationsWatchFunc();
        unregistrationDestroyOnFunc();
    });
    initUmlDiagram();
    $scope.loadCimModel();
});
