app.controller('CimModelDictionaryEditorCtrl', function ($scope, $http, clientSettings, $location, notificationService, $modal, $upload, $window, $rootScope, blockUI, guid, language) {
    $scope.tree = {};
    $scope.treeGrid = {};
    $scope.treeGridData = [];
    $scope.selectedTreeGridItem = {};
    $scope.selectTreeGridNode = function (branch) {
        $scope.selectedTreeGridItem = branch;
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/IsClassHasSelfLink', {
            classUniqueCode: $scope.selectedTreeGridItem.TargetUniqueCode,
        })
            .then(function (response) {
            $scope.selfLinkButtonEnabled = response.data.answer;
        }, function (response) {
            $scope.selfLinkButtonEnabled = false;
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.columnTreeGridDef = [
        {
            field: 'CreateGroupNode',
            displayName: language.getElementValue('cimModelGroupHodeHnt'),
            cellTemplate: "<div>{{ row.branch[col.field] ? '    ✓   ' : '' }}</div>",
        },
        {
            field: 'ShowRecursiveSelfLinks',
            displayName: language.getElementValue('cimModelViewRecoursiveLinkHnt'),
            cellTemplate: "<div>{{ row.branch[col.field] ? '    ✓   ' : '' }}</div>",
        },
    ];
    $scope.expandTreeGridDef = {
        field: 'Class',
        displayName: language.getElementValue('cimModelClassHdr'),
    };
    $scope.columns = [{ header: language.getElementValue('cimModelManualsHdr') }];
    $scope.plugins = ['types', 'wholerow', 'grid', 'contextmenu'];
    $scope.startingData = {
        id: 'none',
        text: language.getElementValue('cimModelAddFirstDictionaryHdr'),
        type: 'none',
    };
    $scope.dictionaries = [];
    $scope.contextMenu = {
        items: function (node) {
            var items = {
                Create: {
                    label: language.getElementValue('cimModelAddHdr'),
                    action: function () {
                        $scope.addDictionaryProfile();
                    },
                },
            };
            if (node.id != 'none') {
                items.Delete = {
                    label: language.getElementValue('cimModelDeleteHdr'),
                    action: function () {
                        $scope.removeDictionaryProfile();
                    },
                };
            }
            return items;
        },
    };
    $scope.selfLinkButtonEnabled = false;
    $scope.$watch('tree.selectedElements', function () {
        if ($scope.tree.selectedElements === undefined || $scope.tree.selectedElements == '')
            return;
        var node = _.find($scope.dictionaries, function (arg) {
            return arg.Id == $scope.tree.selectedElements[0];
        });
        if (node === undefined)
            return;
        $scope.selectedNode = node;
        $scope.settingDictionaryName = String.Format(language.getElementValue('cimModelSettingDictionaryNameHdr'), $scope.selectedNode.Name);
    });
    var drawTree = function () {
        $scope.treeNodes = _.map($scope.dictionaries, function (arg) {
            return {
                id: arg.Id,
                parent: '#',
                text: arg.Name,
                type: 'folder',
            };
        });
        $scope.tree.element.jstree().settings.core.data =
            $scope.treeNodes.length == 0 ? $scope.startingData : $scope.treeNodes;
        $scope.tree.element.jstree().refresh();
    };
    $scope.$watch('selectedNode', function (after, before) {
        if (after == undefined)
            return;
        $scope.drawTreeGrid(after.Items);
        $scope.selectedTreeGridItem = undefined;
    });
    $scope.loadProfiles = function () {
        $http.get(clientSettings.getServerInstance() + '/CimModel/GetDictionaryProfiles').then(function (response) {
            $scope.dictionaries = response.data;
            drawTree();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.addClass = function (addMode) {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/DictionaryEditor/CimAddClassWindow.html',
            controller: addClassCtrl,
            resolve: {
                data: function () {
                    return {
                        selectedNodeUniqueCode: addMode === 'child'
                            ? $scope.selectedTreeGridItem == undefined
                                ? ''
                                : $scope.selectedTreeGridItem.TargetUniqueCode
                            : '',
                    };
                },
            },
            windowClass: 'target-modal-window',
        })
            .result.then(function (selectedElement) {
            var newId = guid.new();
            var newRecord = {
                name: selectedElement.name,
                profileId: $scope.selectedNode.Id,
                rootNode: addMode === 'child'
                    ? $scope.selectedTreeGridItem == undefined
                        ? undefined
                        : $scope.selectedTreeGridItem.Id
                    : undefined,
                nodeId: newId,
                sourceUniqueClassName: addMode === 'main'
                    ? undefined
                    : $scope.selectedTreeGridItem == undefined
                        ? undefined
                        : $scope.selectedTreeGridItem.TargetUniqueCode,
                targetUniqueClassName: selectedElement.uniqueCode,
                createGroup: addMode === 'child'
                    ? $scope.selectedTreeGridItem == undefined
                        ? true
                        : selectedElement.createGroup
                    : true,
                isBackLink: false,
            };
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/AddDictionaryProfileNode', newRecord)
                .then(function (response) {
                var newItem = {
                    Id: newId,
                    Items: [],
                    LinkUniqueCode: '',
                    Name: newRecord.name,
                    ParentId: newRecord.rootNode,
                    SourceUniqueCode: newRecord.sourceUniqueClassName,
                    TargetUniqueCode: newRecord.targetUniqueClassName,
                    CreateGroupNode: newRecord.createGroup,
                    IsBackLink: false,
                    ShowRecursiveSelfLinks: false,
                };
                if ($scope.selectedNode.Items == undefined || $scope.selectedNode.length == 0) {
                    $scope.selectedNode.Items = [];
                }
                if (newItem.ParentId === undefined) {
                    $scope.selectedNode.Items.push(newItem);
                }
                _.each($scope.selectedNode.Items, function (item) {
                    $scope.findAndAddChildNode(newItem, item);
                });
                var newTreeGridNode = {
                    Class: newRecord.name,
                    Id: newId,
                    CreateGroupNode: newRecord.createGroup,
                    ShowRecursiveSelfLinks: false,
                    TargetUniqueCode: newRecord.targetUniqueClassName,
                    children: [],
                    expanded: false,
                    selected: false,
                };
                if (addMode === 'main') {
                    var branch = $scope.treeGrid.add_root_branch(newTreeGridNode);
                    $scope.treeGrid.select_branch(branch);
                }
                else {
                    var branch = $scope.treeGrid.add_branch($scope.selectedTreeGridItem, newTreeGridNode);
                    $scope.treeGrid.select_branch(branch);
                }
                $rootScope.$broadcast('cimDictionarieListChanged');
                notificationService.showMessage(language.getElementValue('cimModelSuccessLinkAddedMsg'));
            }, function (response) {
                notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
            });
        });
    };
    $scope.removeClass = function () {
        if ($scope.selectedTreeGridItem == undefined)
            return;
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/RemoveDictionaryProfileNode', {
            profileId: $scope.selectedNode.Id,
            nodeId: $scope.selectedTreeGridItem.Id,
        })
            .then(function () {
            $scope.selectedNode.Items = _.reject($scope.selectedNode.Items, function (arg) {
                return arg.Id == $scope.selectedTreeGridItem.Id;
            });
            _.each($scope.selectedNode.Items, function (item) {
                $scope.findAndRemoveChildNode(item, $scope.selectedTreeGridItem.Id);
            });
            $scope.treeGridData = $scope.filterTreeGrid($scope.treeGridData, $scope.selectedTreeGridItem.Id);
            notificationService.showMessage(language.getElementValue('cimModelSuccessLinkDeletedMsg'));
            $scope.selectedTreeGridItem = undefined;
            $rootScope.$broadcast('cimDictionarieListChanged');
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.filterTreeGrid = function (data, id) {
        var r = data.filter(function (o) {
            if (o.children.length > 0)
                o.children = $scope.filterTreeGrid(o.children, id);
            return o.Id !== id;
        });
        return r;
    };
    $scope.setGroupClassProperty = function () {
        if ($scope.selectedTreeGridItem == undefined || $scope.selectedTreeGridItem.level == 1) {
            notificationService.warnMessage(language.getElementValue('cimModelUnselectGroupNodeOneLevelMsg'));
            return;
        }
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/SetGroupClassProperty', {
            profileId: $scope.selectedNode.Id,
            nodeId: $scope.selectedTreeGridItem.Id,
        })
            .then(function () {
            var id = $scope.selectedTreeGridItem.Id;
            if ($scope.selectedTreeGridItem.CreateGroupNode == undefined)
                $scope.selectedTreeGridItem.CreateGroupNode = false;
            $scope.selectedTreeGridItem.CreateGroupNode = !$scope.selectedTreeGridItem.CreateGroupNode;
            notificationService.showMessage(language.getElementValue('cimModelSuccesGroupChangeMsg'));
            $rootScope.$broadcast('cimDictionarieListChanged');
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.setSelfLinkProperty = function () {
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/SetShowSelfLinksProperty', {
            profileId: $scope.selectedNode.Id,
            nodeId: $scope.selectedTreeGridItem.Id,
        })
            .then(function () {
            var id = $scope.selectedTreeGridItem.Id;
            if ($scope.selectedTreeGridItem.ShowRecursiveSelfLinks == undefined)
                $scope.selectedTreeGridItem.ShowRecursiveSelfLinks = false;
            $scope.selectedTreeGridItem.ShowRecursiveSelfLinks =
                !$scope.selectedTreeGridItem.ShowRecursiveSelfLinks;
            var node = _.find($scope.selectedNode.Items, function (arg) {
                return arg.Id == id;
            });
            if (!_.isUndefined(node)) {
                node.ShowRecursiveSelfLinks = $scope.selectedTreeGridItem.ShowRecursiveSelfLinks;
            }
            notificationService.showMessage(language.getElementValue('cimModelSuccesGroupChangeMsg'));
            $rootScope.$broadcast('cimDictionarieListChanged');
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.findAndAddChildNode = function (newNode, currentNode) {
        if (currentNode == undefined)
            return;
        if (newNode.ParentId == currentNode.Id) {
            currentNode.Items.push(newNode);
        }
        else {
            _.each(currentNode.Items, function (item) {
                $scope.findAndAddChildNode(newNode, item);
            });
        }
    };
    $scope.findAndRemoveChildNode = function (currentNode, nodeId) {
        if (currentNode == undefined || currentNode.Items == undefined)
            return;
        currentNode.Items = _.reject(currentNode.Items, function (arg) {
            return arg.Id == nodeId;
        });
        _.each(currentNode.Items, function (item) {
            $scope.findAndRemoveChildNode(item, nodeId);
        });
    };
    $scope.init = function () {
        $scope.loadProfiles();
        $('#classTreeContainer').css('max-height', window.innerHeight - 150 + 'px');
    };
    $scope.initTreeGrid = function (tree, parent) {
        tree.forEach(function (item) {
            var newNode = {
                Class: item.Name,
                Id: item.Id,
                CreateGroupNode: item.CreateGroupNode,
                ShowRecursiveSelfLinks: item.ShowRecursiveSelfLinks,
                TargetUniqueCode: item.TargetUniqueCode,
                children: [],
                expanded: false,
                selected: false,
            };
            if (item.Items.length !== 0) {
                $scope.initTreeGrid(item.Items, newNode);
                if (parent === undefined) {
                    $scope.treeGridData.push(newNode);
                }
                else {
                    parent.children.push(newNode);
                }
            }
            else {
                if (parent === undefined) {
                    $scope.treeGridData.push(newNode);
                }
                else {
                    parent.children.push(newNode);
                }
            }
        });
    };
    $scope.drawTreeGrid = function (items) {
        $scope.treeGridData = items;
        var treeGridSettings = {
            dataType: 'json',
            dataFields: [
                { name: 'Id', type: 'string' },
                { name: 'ParentId', type: 'string' },
                { name: 'TargetUniqueCode', type: 'string' },
                { name: 'Name', type: 'string' },
                { name: 'Items', type: 'array' },
                { name: 'CreateGroupNode', type: 'bool' },
                { name: 'ShowRecursiveSelfLinks', type: 'bool' },
            ],
            hierarchy: {
                root: 'Items',
            },
            id: 'Id',
            localData: items,
        };
        $scope.treeGridData = [];
        $scope.initTreeGrid(items);
    };
    $scope.addDictionaryProfile = function () {
        $scope.addDictionaryModalOk = function () {
            $scope.addDictionaryModalInstance.close({ ok: true });
        };
        $scope.addDictionaryModalCancel = function () {
            $scope.addDictionaryModalInstance.close({ ok: false });
        };
        $scope.newName = {
            Value: language.getElementValue('dictionaryHdr') + ' ' + parseInt($scope.dictionaries.length) + 1,
        };
        var source = '<div class="modal-header"><span class="modal-title">{{ \'dictionaryHdr\' | lng }}</span></div>' +
            '<div class="modal-body"><input ng-model="newName.Value" type="text" class="form-control" placeholder="{{ \'cimModelDictionaryNamePch\' | lng }}"></div>' +
            '<div class="modal-footer"><div class="btn btn-primary" ng-click="addDictionaryModalOk()">{{ \'confirmBtn\' | lng }}</div><div class="btn btn-default" ng-click="addDictionaryModalCancel()">{{ \'cancelBtn\' | lng }}</div></div>';
        $scope.addDictionaryModalInstance = $modal.open({
            template: source,
            windowClass: 'app-modal-window',
            backdrop: 'static',
            scope: $scope,
        });
        $scope.addDictionaryModalInstance.result.then(function (res) {
            if (!_.isUndefined(res.ok) && res.ok) {
                if ($scope.newName.Value == '') {
                    notificationService.warnMessage(language.getElementValue('cimModelNoInputDictionaryNameMsg'));
                    return;
                }
                var item = _.find($scope.dictionaries, function (arg) {
                    return arg.Name == $scope.newName.Value;
                });
                if (item != undefined) {
                    notificationService.warnMessage(String.Format(language.getElementValue('cimModelDictionaryAlreadyCreateMsg'), $scope.newName.Value));
                    return;
                }
                var newId = guid.new();
                $http
                    .post(clientSettings.getServerInstance() + '/CimModel/AddDictionaryProfile', {
                    id: newId,
                    name: $scope.newName.Value,
                })
                    .then(function () {
                    $scope.loadProfiles();
                    $rootScope.$broadcast('cimDictionarieListChanged');
                }, function (response) {
                    notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
                });
            }
        }, function () { });
    };
    $scope.removeDictionaryProfile = function () {
        if ($scope.selectedNode == undefined || $scope.selectedNode.Id == undefined)
            return;
        $scope.deleteDictionaryModalOk = function () {
            $scope.deleteDictionaryModal.close({ ok: true });
        };
        $scope.deleteDictionaryModalCancel = function () {
            $scope.deleteDictionaryModal.close({ ok: false });
        };
        var source = '<div class="modal-header"><span class="modal-title">{{ \'cimModelDictionaryDeleteModalHdr\' | lng }}</span></div>' +
            '<div class="modal-body">{{ \'cimModelDictionaryDeleteModalQuestionHdr\' | lng }}</div>' +
            '<div class="modal-footer"><div class="btn btn-primary" ng-click="deleteDictionaryModalOk()">{{ \'confirmBtn\' | lng }}</div><div class="btn btn-default" ng-click="deleteDictionaryModalCancel()">{{ \'cancelBtn\' | lng }}</div></div>';
        $scope.deleteDictionaryModal = $modal.open({
            template: source,
            windowClass: 'app-modal-window',
            backdrop: 'static',
            scope: $scope,
        });
        $scope.deleteDictionaryModal.result.then(function (res) {
            if (!_.isUndefined(res.ok) && res.ok) {
                $http
                    .post(clientSettings.getServerInstance() + '/CimModel/RemoveDictionaryProfile', {
                    id: $scope.selectedNode.Id,
                })
                    .then(function () {
                    $scope.loadProfiles();
                    $scope.selectedTreeGridItem = undefined;
                    $scope.selectedNode = undefined;
                    $rootScope.$broadcast('cimDictionarieListChanged');
                }, function (response) {
                    notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
                });
            }
        }, function () { });
    };
    $scope.renameDictionary = function (parameters) {
        var match = _.find($scope.treeNodes, function (arg) {
            return arg.text == $scope.selectedNode.Name && arg.id != $scope.selectedNode.Id;
        });
        if (!_.isUndefined(match)) {
            notificationService.warnMessage(language.getElementValue('cimModelDictionaryAlreadyExistMsg'));
            return;
        }
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/RenameDictionary', {
            id: $scope.selectedNode.Id,
            name: $scope.selectedNode.Name,
        })
            .then(function () {
            var node = _.find($scope.treeNodes, function (arg) {
                return arg.id == $scope.selectedNode.Id;
            });
            node.text = $scope.selectedNode.Name;
            $scope.tree.element.jstree('refresh');
            setTimeout(function () {
                $scope.tree.element.jstree().deselect_all();
                $scope.tree.element.jstree().select_node(node.id);
                $rootScope.$broadcast('cimDictionarieListChanged');
                notificationService.showMessage(language.getElementValue('cimModelSuccessRenameDictionaryMsg'));
            }, 300);
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            $scope.init();
        }
    });
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        unregistrationJstreeReadyOnFunc();
        unregistrationDestroyFunc();
    });
});
var addClassCtrl = function ($scope, $modalInstance, $http, clientSettings, notificationService, data, language) {
    $scope.tree = {};
    $scope.data = data;
    $scope.columns = [{ header: language.getElementValue('cimModelClassesHdr') }];
    $scope.plugins = ['types', 'wholerow', 'grid'];
    $scope.startingData = {
        id: 'none',
        text: language.getElementValue('cimModelDictionaryClassesEmptyMsg'),
        type: 'none',
    };
    $scope.createGroup = false;
    $scope.init = function () {
        $http
            .get(clientSettings.getServerInstance() +
            '/CimModel/GetConnectedNodes?uniqueCode=' +
            data.selectedNodeUniqueCode)
            .then(function (response) {
            $scope.treeData = response.data;
            if ($scope.treeData.length != 0)
                $scope.drawTree();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.drawTree = function () {
        $scope.treeNodes = _.map($scope.treeData, function (arg) {
            return {
                id: arg.UniqueCode,
                parent: arg.BaseClassUniqueCode,
                text: arg.Name,
                type: 'folder',
            };
        });
        $scope.tree.element.jstree().settings.core.data =
            $scope.treeNodes.length == 0 ? $scope.startingData : $scope.treeNodes;
        $scope.tree.element.jstree().refresh();
    };
    $scope.ok = function () {
        var selected = _.find($scope.treeNodes, function (arg) {
            return arg.id === $scope.tree.selectedElements[0];
        });
        $modalInstance.close({
            uniqueCode: $scope.tree.selectedElements[0],
            name: selected.text,
            createGroup: $scope.createGroup,
        });
    };
    $scope.cancel = function () {
        $modalInstance.dismiss('cancel');
    };
    var unregistrationJstreeRefreshOnFunc = $scope.$on('jstreeRefresh', function (event, data) {
    });
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            $scope.init();
        }
    });
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        $scope.tree.element.jstree().destroy();
        unregistrationJstreeRefreshOnFunc();
        unregistrationJstreeReadyOnFunc();
        unregistrationDestroyFunc();
    });
    $scope.init();
};
