var SideMenuController = (function () {
    function SideMenuController(permissionService, authentication, licenseStorage, diagnosticService, languageService) {
        this.authentication = authentication;
        this.licenseStorage = licenseStorage;
        this.diagnosticService = diagnosticService;
        this.languageService = languageService;
        this.permissions = permissionService.getAll();
    }
    SideMenuController.prototype.getCurrentUserTitle = function () {
        var user = this.authentication.user;
        return _.isDefined(user)
            ? this.languageService.getElementValue('userHdr') + ': ' + user.name
            : '';
    };
    SideMenuController.prototype.isReportMenuItemVisible = function () {
        return (this.licenseStorage.hasModule(62376423) &&
            (this.authentication.hasPermissionStartWith('ReportView_') ||
                this.authentication.hasPermission(this.permissions.ReportTrendsView) ||
                this.authentication.hasPermission(this.permissions.ReportAdministrate)));
    };
    SideMenuController.prototype.isDictionariesMenuItemVisible = function () {
        return ((this.licenseStorage.hasModule(87623764) &&
            (this.authentication.hasPermission(this.permissions.CimView) ||
                this.authentication.hasPermission(this.permissions.CimAdmin))));
    };
    SideMenuController.prototype.isSwitchoverFormsMenuItemVisible = function () {
        return (this.licenseStorage.hasModule(6239971) &&
            (this.authentication.hasPermission(this.permissions.SwitchoverFormView) ||
                this.authentication.hasPermission(this.permissions.SwitchoverFormTemplateAdmin) ||
                this.isSwitchoverFormDictionariesVisible()));
    };
    SideMenuController.prototype.isSwitchoverFormDictionariesVisible = function () {
        return (this.licenseStorage.hasModule(6239971) &&
            (this.authentication.hasPermission(this.permissions.SwitchoverFormOperationsDictionaryView) ||
                this.authentication.hasPermission(this.permissions.SwitchoverFormConditionsDictionaryView) ||
                this.authentication.hasPermission(this.permissions.SwitchoverFormAlarmsDictionaryView)));
    };
    SideMenuController.prototype.isOperationTimeMenuItemVisible = function () {
        return (this.licenseStorage.hasModule(6526756) &&
            (this.authentication.hasPermission(this.permissions.OperationTimeView) ||
                this.authentication.hasPermission(this.permissions.OperationTimeAdmin)));
    };
    SideMenuController.prototype.isExternalConnectionEditMenuItemVisible = function () {
        return (this.authentication.hasPermission(this.permissions.ExternalConnectionEdit) ||
            this.authentication.hasPermission(this.permissions.ExternalConnectionView));
    };
    SideMenuController.prototype.hasReportViewPermissions = function () {
        return this.authentication.hasPermissionStartWith('ReportView_');
    };
    SideMenuController.prototype.hasAdminPermissions = function () {
        return this.authentication.hasPermission(this.permissions.Administrate);
    };
    SideMenuController.prototype.toggleMenuItem = function (event) {
        var element = event.target;
        _.forEach(element.parentElement.parentElement.parentElement.querySelectorAll('.open'), function (openedElement) {
            if (openedElement !== element.parentElement) {
                openedElement.classList.remove('open');
            }
        });
        element.parentElement.classList.add('open');
    };
    SideMenuController.$inject = [
        'permissionService',
        'authentication',
        'licenseStorage',
        'diagnosticService',
        'language'
    ];
    return SideMenuController;
}());
