var OpcSettingsCtrl = (function () {
    function OpcSettingsCtrl(parentScope, modalService, notificationService, opcConnectionProvider, language) {
        this.parentScope = parentScope;
        this.modalService = modalService;
        this.notificationService = notificationService;
        this.opcConnectionProvider = opcConnectionProvider;
        this.language = language;
        this.connectionTypes = [6];
        this.watchFunctions = [];
    }
    OpcSettingsCtrl.prototype.init = function () {
        var selfScope = this;
        this.opcFunctions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('onCurrentTime', selfScope.language.getElementValue('reportParameterOpcInCurrentTimeHdr'), 'OpcValue'),
            new SelectSourceFunctionsItem('historical', selfScope.language.getElementValue('reportParameterOpcOnPeriodHdr'), 'OpcValue[]'),
            new SelectSourceFunctionsItem('onTimestamp', selfScope.language.getElementValue('reportParameterOnTimeStampHdr'), 'OpcValue')
        ], function (func) {
            return func.ident === selfScope.parentScope.param.Opc.func;
        }, function (after, before) {
            if (after === before) {
                return;
            }
            selfScope.parentScope.param.Opc.func = after.ident;
            if (after.ident === 'onTimestamp') {
                selfScope.parentScope.param.Opc.includeBorders = true;
            }
            selfScope.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
            if (!selfScope.canEdited()) {
                selfScope.parentScope.param.Editable = false;
            }
        });
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return selfScope.parentScope.param.Opc.startPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            selfScope.parentScope.param.Opc.startPeriod = after.ident;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return selfScope.parentScope.param.Opc.endPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            selfScope.parentScope.param.Opc.endPeriod = after.ident;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return selfScope.parentScope.param.Opc;
        }, function (before, after) {
            if (before === after || _.isUndefined(after)) {
                return;
            }
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        }, true));
        if (this.opcFunctions.selected) {
            this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.opcFunctions.selected.returnType);
            this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        }
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    OpcSettingsCtrl.prototype.onConnectionSelected = function (connection) {
        this.selectedConnection = connection;
        if (_.isUndefined(this.selectedConnection)) {
            return;
        }
        if (_.any(this.selectedConnection.specializedSettings, function (settings) { return settings.opc.standard === 0; })
            && (!this.opcFunctions.selected || this.opcFunctions.selected && this.opcFunctions.selected.ident !== 'onCurrentTime')) {
            this.opcFunctions.selected = _.find(this.opcFunctions, function (func) { return func.ident === 'onCurrentTime'; });
        }
    };
    OpcSettingsCtrl.prototype.filterOpcFunctions = function () {
        var _this = this;
        return function (item) {
            if (_.isUndefined(_this.selectedConnection)) {
                return false;
            }
            if (_.any(_this.selectedConnection.specializedSettings, function (settings) { return settings.opc.standard === 0; })) {
                return item.ident === 'onCurrentTime';
            }
            return true;
        };
    };
    OpcSettingsCtrl.prototype.canCheckTagAddress = function () {
        return _.isDefined(this.parentScope.param.Opc.connectionGuid) && !_.isEmpty(this.parentScope.param.Opc.address);
    };
    OpcSettingsCtrl.prototype.checkOpcTagAddress = function () {
        var _this = this;
        this.opcConnectionProvider
            .checkOpcTagAddress(this.parentScope.param.Opc.address, this.parentScope.param.Opc.connectionGuid)
            .then(function (checkResult) {
            if (checkResult) {
                _this.notificationService.showMessage(_this.language.getElementValue('reportTagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('reportTagAddressIsNotExistMsg'));
            }
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorCheckTagAddressMsg'), error);
        });
    };
    OpcSettingsCtrl.prototype.isHistoricalParameter = function () {
        return this.opcFunctions && this.opcFunctions.selected && this.opcFunctions.selected.ident === 'historical';
    };
    OpcSettingsCtrl.prototype.isHistoricalOnTimeParameter = function () {
        return this.opcFunctions
            && this.opcFunctions.selected
            && this.opcFunctions.selected.ident === 'onTimestamp';
    };
    OpcSettingsCtrl.prototype.isOpcDaSource = function () {
        return this.selectedConnection && _.all(this.selectedConnection.specializedSettings, function (settings) { return settings.opc.standard === 0; });
    };
    OpcSettingsCtrl.prototype.showTimeStamps = function () {
        return this.isHistoricalParameter() || this.isHistoricalOnTimeParameter();
    };
    OpcSettingsCtrl.prototype.clearTag = function () {
        this.parentScope.param.Opc.name = '';
        this.parentScope.param.Opc.address = '';
    };
    OpcSettingsCtrl.prototype.showOpcTagsTree = function () {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return _this.selectedConnection.id; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return [TagTreeType.Opc]; },
                tagAddress: function () { return _this.parentScope.param.Opc.address; }
            },
        });
        modalInstance.result.then(function (tags) {
            _this.parentScope.param.Opc.name = tags[0].name;
            _this.parentScope.param.Opc.address = tags[0].address;
        });
    };
    OpcSettingsCtrl.prototype.destroy = function () {
        this.opcFunctions.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    OpcSettingsCtrl.prototype.getFormula = function () {
        var connection = this.parentScope.param.Opc.connectionGuid;
        var address = this.parentScope.param.Opc.address;
        if (_.isUndefined(connection)) {
            connection = '';
        }
        if (!this.opcFunctions.selected) {
            return '';
        }
        var functionName = '';
        switch (this.opcFunctions.selected.ident) {
            case 'onCurrentTime':
                functionName = 'GetOpcValueByConnection';
                break;
            case 'historical':
                functionName = 'GetOpcHdaValuesByConnection';
                break;
            case 'onTimestamp':
                functionName = 'GetOpcHdaValueByConnection';
                break;
        }
        var formula = String.Format('{0}(@"{1}", @"{2}"', functionName, connection, address);
        if (this.isHistoricalParameter()) {
            formula += String.Format(', {0}, {1}, {2}, {3}', this.parentScope.param.Opc.startPeriod, this.parentScope.param.Opc.endPeriod, this.parentScope.param.Opc.includeBorders.toString(), this.parentScope.param.Opc.maxFields.toString());
        }
        if (this.isHistoricalOnTimeParameter()) {
            formula += String.Format(', {0}', this.parentScope.param.Opc.startPeriod);
        }
        return formula + ')';
    };
    OpcSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return (_.isUndefined(this.parentScope.param.Opc.connectionGuid)
            || (this.isHistoricalParameter() && this.parentScope.param.Opc.maxFields.toString() === ''));
    };
    OpcSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Opc.canEdited();
    };
    OpcSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Opc.canPlanned();
    };
    OpcSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Opc.canBacklight();
    };
    OpcSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Opc.canPredefined();
    };
    return OpcSettingsCtrl;
}());
