var PiramidaSettings = (function () {
    function PiramidaSettings(templateHasStep) {
        this.func = 'lastValueOnPeriod';
        this.parameter = 12;
        this.startDate = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endDate = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
        this.discreteSettings = null;
        this.connectionGuid = '';
        this.objCode = 0;
        this.objItem = 0;
    }
    PiramidaSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new PiramidaSettings();
        clone.func = obj.func;
        clone.host = obj.host;
        clone.db = obj.db;
        clone.password = obj.password;
        clone.user = obj.user;
        clone.objectName = obj.objectName;
        clone.parameter = obj.parameter;
        clone.startDate = obj.startDate;
        clone.endDate = obj.endDate;
        clone.objCode = obj.objCode;
        clone.objItem = obj.objItem;
        clone.discreteSettings = PiramidaDiscreteSettings.clone(obj.discreteSettings);
        clone.connectionGuid = obj.connectionGuid;
        return clone;
    };
    PiramidaSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func
            && obj.host === other.host
            && obj.db === other.db
            && obj.password === other.password
            && obj.user === other.user
            && obj.objectName === other.objectName
            && obj.parameter === other.parameter
            && obj.startDate === other.startDate
            && obj.endDate === other.endDate
            && obj.objCode === other.objCode
            && obj.objItem === other.objItem
            && obj.connectionGuid === other.connectionGuid
            && PiramidaDiscreteSettings.isEqual(obj.discreteSettings, other.discreteSettings));
    };
    PiramidaSettings.prototype.canEdited = function () {
        return this.func === 'lastValueOnPeriod';
    };
    PiramidaSettings.prototype.canPlanned = function () {
        return true;
    };
    PiramidaSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    PiramidaSettings.prototype.canPredefined = function () {
        return false;
    };
    PiramidaSettings.prototype.test = function (first, second) { };
    return PiramidaSettings;
}());
