var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var SpecificDateSettingsCtrl = (function () {
    function SpecificDateSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.watchFunctions = [];
        this.defaultFormat = 'dd.MM HH:mm';
        this.defaultDates = [];
        this.availableDates = [];
        this.ManualDateName = 'ManualDate';
        this.defaultDates = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], (parentScope.reportTemplate.ReportType === 1 ? [
            { ident: 'StartDate', name: this.language.getElementValue('reportDateStartDateHdr') },
            { ident: 'EndDate', name: this.language.getElementValue('reportDateEndDateHdr') },
        ] : [
            { ident: 'StartDate', name: this.language.getElementValue('reportDateHdr') },
        ]), true), [
            { ident: 'ReportCreationDate', name: this.language.getElementValue('reportDataCreateDateHdr') },
            { ident: 'ReportUpdateDate', name: this.language.getElementValue('reportDataUpdateHdr') }
        ], false), (parentScope.reportTemplate.HasStep ? [
            { ident: 'Timestamp', name: this.language.getElementValue('reportDateStepEndHdr') },
        ] : []), true), [
            { ident: 'ReportDay', name: this.language.getElementValue('reportDateReportDayHdr') },
            { ident: 'ReportMonth', name: this.language.getElementValue('reportDateReportMonthHdr') },
            { ident: 'ReportYear', name: this.language.getElementValue('reportDateReportYearHdr') },
            { ident: 'Now', name: this.language.getElementValue('reportDateCurrentDateHdr') },
            { ident: this.ManualDateName, name: this.language.getElementValue('dateHdr') },
        ], false);
    }
    SpecificDateSettingsCtrl.prototype.init = function () {
        var _this = this;
        var otherDateParameters = _.map(_.filter(this.parentScope.reportTemplate.Parameters, function (p) {
            return ((p.Source === 'specificDate' && p.Ident !== _this.parentScope.param.Ident) ||
                (p.ParameterType === 'DateTime' && p.Ident !== _this.parentScope.param.Ident));
        }), function (parameter) {
            return { ident: "%".concat(parameter.Ident, "%"), name: parameter.Ident };
        });
        this.availableDates = __spreadArray(__spreadArray([], this.defaultDates, true), otherDateParameters, true);
        this.selectedDate = _.find(this.availableDates, function (date) { return date.ident === _this.parentScope.param.SpecificDate.parameter; });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.SpecificDate;
        }, function (after) {
            if (after == undefined) {
                return;
            }
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('DateTime');
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    SpecificDateSettingsCtrl.prototype.onManualDateChange = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    SpecificDateSettingsCtrl.prototype.destroy = function () {
        this.watchFunctions.forEach(function (listener) {
            listener();
        });
        this.watchFunctions = [];
    };
    SpecificDateSettingsCtrl.prototype.getFormula = function () {
        var manualDate = this.parentScope.param.SpecificDate.manualDate;
        var formula = this.parentScope.param.SpecificDate.parameter === this.ManualDateName
            ? this.convertToDateTime(manualDate)
            : "".concat(this.parentScope.param.SpecificDate.parameter);
        if (this.parentScope.param.SpecificDate.monthOffset) {
            formula += ".AddMonths(".concat(this.parentScope.param.SpecificDate.monthOffset, ")");
        }
        if (this.parentScope.param.SpecificDate.dayOffset) {
            formula += ".AddDays(".concat(this.parentScope.param.SpecificDate.dayOffset, ")");
        }
        if (this.parentScope.param.SpecificDate.hourOffset) {
            formula += ".AddHours(".concat(this.parentScope.param.SpecificDate.hourOffset, ")");
        }
        if (this.parentScope.param.SpecificDate.minuteOffset) {
            formula += ".AddMinutes(".concat(this.parentScope.param.SpecificDate.minuteOffset, ")");
        }
        if (this.parentScope.param.SpecificDate.secondsOffset) {
            formula += ".AddSeconds(".concat(this.parentScope.param.SpecificDate.secondsOffset, ")");
        }
        return formula;
    };
    SpecificDateSettingsCtrl.prototype.convertToDateTime = function (date) {
        return "DateTime.Parse(\"".concat(date.toISOString(), "\")");
    };
    SpecificDateSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return (_.isEmpty(this.parentScope.param.SpecificDate.parameter));
    };
    SpecificDateSettingsCtrl.prototype.onDateChange = function () {
        this.parentScope.param.SpecificDate.parameter = this.selectedDate.ident;
        this.parentScope.param.SpecificDate.manualDate = this.selectedDate.ident === this.ManualDateName
            ? new Date()
            : undefined;
    };
    SpecificDateSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.SpecificDate.canEdited();
    };
    SpecificDateSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.SpecificDate.canPlanned();
    };
    SpecificDateSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.SpecificDate.canBacklight();
    };
    SpecificDateSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.SpecificDate.canPredefined();
    };
    return SpecificDateSettingsCtrl;
}());
