var WinccSettingsCtrl = (function () {
    function WinccSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.functions = [];
        this.connectionTypes = [5];
        this.watchFunctions = [];
    }
    WinccSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.Wincc.startTimestamp;
        }, function (after, before) {
            if (after === before)
                return;
            self.parentScope.param.Wincc.startTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        this.endPeriods = getVariantsContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function (t) {
            return t.ident === self.parentScope.param.Wincc.endTimestamp;
        }, function (after, before) {
            if (after === before)
                return;
            self.parentScope.param.Wincc.endTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        var afterSelectFunction = function (after) {
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        };
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem(0, this.language.getElementValue('winccGetOnPeriodHdr'), 'WinccValue[]'),
            new SelectSourceFunctionsItem(1, this.language.getElementValue('winccFirstForPeriodHdr'), 'WinccValue'),
            new SelectSourceFunctionsItem(2, this.language.getElementValue('winccLastForPeriodHdr'), 'WinccValue'),
            new SelectSourceFunctionsItem(3, this.language.getElementValue('winccMinForPeriodHdr'), 'WinccValue'),
            new SelectSourceFunctionsItem(4, this.language.getElementValue('winccMaxForPeriodHdr'), 'WinccValue'),
            new SelectSourceFunctionsItem(5, this.language.getElementValue('winccAvgForPeriod'), 'WinccValue'),
            new SelectSourceFunctionsItem(6, this.language.getElementValue('winccSumPeriodHdr'), 'double'),
        ], function (t) {
            return t.ident === self.parentScope.param.Wincc.aggregationType;
        }, function (after, before) {
            if (after === before)
                return;
            self.parentScope.param.Wincc.aggregationType = after.ident;
            afterSelectFunction(after);
        });
        var filteredParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (i) {
            return i.Ident !== _this.parentScope.param.Ident && i.ParameterType === 'string';
        });
        this.reportParameters = getVariantsContainer(this.parentScope, _.map(filteredParameters, function (parameter) {
            return new UiSelectItem(parameter.Ident, parameter.Source);
        }), function (t) {
            return t.ident === self.parentScope.param.Wincc.dbNameParameterIdent;
        }, function (after, before) {
            if (after === before)
                return;
            self.parentScope.param.Wincc.dbNameParameterIdent = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Wincc;
        }, function (after, before) {
            if (after == undefined || after === before) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        afterSelectFunction(this.functions.selected);
    };
    WinccSettingsCtrl.prototype.destroy = function () {
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        this.functions.destroy();
        this.reportParameters.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
        this.watchFunctions = [];
    };
    WinccSettingsCtrl.prototype.getFormula = function () {
        var address = this.parentScope.param.Wincc.tagName == undefined ? '' : this.parentScope.param.Wincc.tagName;
        var sql = "TAG:R,'{0}','{1}','{2}'";
        var sqlParams = String.Format('tagName, tsFromStr, tsToStr', address);
        if (this.functions.selected.ident !== 0) {
            sql += ",'TIMESTEP={3},{4}'";
            sqlParams += String.Format(', (int){0}.Subtract({1}).TotalSeconds, {2}', this.parentScope.param.Wincc.endTimestamp, this.parentScope.param.Wincc.startTimestamp, this.parentScope.param.Wincc.aggregationType.toString());
        }
        var winccDbName = _.isDefined(this.parentScope.param.Wincc.dbNameParameterIdent)
            ? String.Format('%{0}%', this.parentScope.param.Wincc.dbNameParameterIdent)
            : '""';
        var formula = String.Format('var tagName = @"{0}";\n' +
            '\n' +
            'var tsFromStr = {1}\n' +
            '       .ToUniversalTime()\n' +
            '       .ToString("yyyy-MM-dd HH:mm:ss");\n' +
            '\n' +
            'var tsToStr = {2}\n' +
            '       .ToUniversalTime()\n' +
            '       .ToString("yyyy-MM-dd HH:mm:ss");\n' +
            '\n' +
            'var sql = string.Format(@"{3}",\n' +
            '      {4});\n' +
            '\n' +
            'var externalConnectionId = "{5}";\n' +
            'var dbName = {6};\n' +
            '\n', address, this.parentScope.param.Wincc.startTimestamp, this.parentScope.param.Wincc.endTimestamp, sql, sqlParams, this.parentScope.param.Wincc.connectionGuid, winccDbName);
        if (this.functions.selected.ident === 0) {
            formula +=
                'var result = WinccQueryAsStringArrayByConnection(externalConnectionId, sql, dbName);\n' +
                    'return result.Length > 0\n' +
                    '   ? result.Select(i => new WinccValue(tagName,\n' +
                    '        Double.Parse(i[2].Replace(",", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator)\n' +
                    '            .Replace(".", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator)),\n' +
                    '        DateTime.Parse(i[1]).ToLocalTime())).ToArray()\n' +
                    '    : null;';
        }
        else if (this.functions.selected.ident === 6) {
            formula +=
                'var result = WinccQueryAsStringArrayByConnection(externalConnectionId, sql, dbName);\n' +
                    'return result.Length > 0\n' +
                    '   ? Double.Parse(result[0][2].Replace(",", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator)\n' +
                    '       .Replace(".", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator))\n' +
                    '   : 0.0;';
        }
        else {
            formula += String.Format('var result = WinccQueryAsStringArrayByConnection(externalConnectionId, sql, dbName);\n' +
                'var value = result.Length > 0\n' +
                '   ? Double.Parse(result[0][2]\n' +
                '       .Replace(",", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator)\n' +
                '       .Replace(".", NumberFormatInfo.CurrentInfo.NumberDecimalSeparator))\n' +
                '   : default(double?);\n' +
                'return new WinccValue(tagName, value, {0});', this.parentScope.param.Wincc.endTimestamp);
        }
        return formula;
    };
    WinccSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    WinccSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Wincc.canEdited();
    };
    WinccSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Wincc.canPlanned();
    };
    WinccSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Wincc.canBacklight();
    };
    WinccSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Wincc.canPredefined();
    };
    return WinccSettingsCtrl;
}());
