app.directive('copyToClipboard', [
    '$timeout',
    'language',
    'notificationService',
    function ($timeout, language, notificationService) {
        return {
            restrict: 'A',
            link: function (scope, elem, attrs) {
                elem.click(function () {
                    if (attrs.copyToClipboard) {
                        var $temp_input = $('<input>');
                        $('body').append($temp_input);
                        $temp_input.val(attrs.copyToClipboard).select();
                        var isCopied = document.execCommand('copy');
                        $temp_input.remove();
                        if (isCopied) {
                            $timeout(function () {
                                notificationService.infoMessage(language.getElementValue('copiedHnt'));
                            }, 1000);
                        }
                    }
                });
            },
        };
    },
]);
