app.directive('inputFloat', function () {
    return {
        require: 'ngModel',
        link: function (scope, element, attr, ngModelCtrl) {
            var fromUser = function (text) {
                if (!text || text === '-') {
                    return text;
                }
                var result = text.match(/[-]?[0-9]+\.?[0-9]*/g);
                var transformedInput = '0.0';
                if (!_.isNull(result)) {
                    transformedInput = result[0];
                }
                if (transformedInput !== text) {
                    ngModelCtrl.$setViewValue(transformedInput);
                    ngModelCtrl.$render();
                }
                return parseFloat(transformedInput);
            };
            ngModelCtrl.$parsers.push(fromUser);
            element.bind('blur', function () {
                if (ngModelCtrl.$viewValue === '' || ngModelCtrl.$viewValue === '-') {
                    ngModelCtrl.$setViewValue('0.0');
                    ngModelCtrl.$render();
                }
            });
        },
    };
});
