angular.module('kamhpp').directive('inputNumber', function () {
    return {
        require: 'ngModel',
        link: function (scope, element, attr, ngModelCtrl) {
            var minValue = parseInt(attr.min);
            var maxValue = parseInt(attr.max);
            var fromUser = function (text) {
                if (!text) {
                    return text;
                }
                var positiveNumber = parseInt(text.toString().replace(/[^0-9]/g, ''));
                var result = !_.isNaN(positiveNumber) ? positiveNumber : 0;
                if (!_.isNaN(minValue) && result < minValue) {
                    result = minValue;
                }
                if (!_.isNaN(maxValue) && result > maxValue) {
                    result = maxValue;
                }
                ngModelCtrl.$setViewValue(result);
                ngModelCtrl.$render();
                return result;
            };
            ngModelCtrl.$parsers.push(fromUser);
            element.bind('blur', function () {
                if (ngModelCtrl.$viewValue === '') {
                    ngModelCtrl.$setViewValue('0');
                    ngModelCtrl.$render();
                }
            });
        },
    };
});
