app.directive('smsTemplateEditor', function (language) {
    return {
        restrict: 'EA',
        scope: {
            value: '=',
            height: '=?',
            width: '=?',
            configuration: '=?',
            onReady: '&?',
            onChange: '&?',
            onSelectionChange: '&?',
            onKey: '&?',
            onDoubleClick: '&?',
            onContextMenuShow: '&?',
            onContextMenuHide: '&?',
            onDialogDefinition: '&?',
            onMaximize: '&?',
            onChangeMode: '&?',
            onPaste: '&?',
            beforeCommandExec: '&?',
        },
        link: function (scope, element) {
            var _a;
            var options = {
                height: _.isDefined(scope.height) ? scope.height : '100%',
                width: _.isDefined(scope.width) ? scope.width : '100%',
                allowedContent: true,
                language: language.language,
                skin: 'moono-lisa',
                extraPlugins: 'tableresize,autocomplete,base64image,copyformatting',
                removePlugins: 'elementspath,magicline,divarea,div',
                toolbar: scope.configuration.toolbar,
                enterMode: CKEDITOR.ENTER_BR,
                shiftEnterMode: CKEDITOR.ENTER_P
            };
            if (scope.options) {
                _.forEach(scope.options, function (option) {
                    if (option.sharedSpaces) {
                        options['sharedSpaces'] = option.sharedSpaces;
                    }
                });
            }
            CKEDITOR.on('dialogDefinition', function (event) {
                scope === null || scope === void 0 ? void 0 : scope.onDialogDefinition({ editor: editor, evt: event });
            });
            element[0].id = (_a = scope.editorId) !== null && _a !== void 0 ? _a : 'ckeditor';
            var editor = null;
            if (element[0].hasAttribute('contenteditable') &&
                element[0].getAttribute('contenteditable').toLowerCase() == 'true') {
                var div = document.createElement('div');
                div.setAttribute('contenteditable', 'true');
                element[0].appendChild(div);
                editor = CKEDITOR.inline(div, options);
            }
            else {
                editor = CKEDITOR.replace(element[0], options);
                CKEDITOR.config.contentsCss = [
                    'ng1/dist/src/css/bootstrap.css',
                    'ng1/dist/src/css/openSansFont.css',
                    'ng1/dist/src/UserDocuments/reportPage.css',
                    'ng1/dist/src/UserDocuments/Administration/TemplateEdit/TemplateMarkup/reportTemplateMarkupEditor.css',
                ];
            }
            var openSansFont = 'Open Sans/Open Sans, sans-serif;';
            if (!CKEDITOR.config.font_names.includes(openSansFont)) {
                CKEDITOR.config.font_names = openSansFont + CKEDITOR.config.font_names;
            }
            _.forEach(scope.configuration.buttons, function (button) {
                editor.addCommand(button.command.name, {
                    state: button.command.state,
                    preserveState: button.command.preserveState,
                    exec: function (editor, data) {
                        button.command.execute(editor, data);
                        return true;
                    },
                    readOnly: button.command.readOnly,
                    canUndo: button.command.canUndo
                });
                editor.ui.addButton(button.name, {
                    command: button.command.name,
                    label: button.label,
                    toolbar: button.toolbar,
                });
            });
            editor.on('instanceReady', function () {
                _.forEach(scope.configuration.contextCommandGroups, function (group) {
                    editor.addMenuGroup(group.name, group.order);
                    if (group.getItems) {
                        editor.addMenuItem(group.name, {
                            label: group.label,
                            group: group.name,
                            icon: undefined,
                            getItems: function () { return group.getItems(editor); }
                        });
                    }
                    _.forEach(group.menuItems, function (menuItem) {
                        var command = editor.getCommand(menuItem.command.name);
                        if (_.isUndefined(command)) {
                            editor.addCommand(menuItem.command.name, {
                                state: menuItem.command.state,
                                exec: function (editor, data) {
                                    menuItem.command.execute(editor, data);
                                    return true;
                                }
                            });
                        }
                        editor.addMenuItem(menuItem.command.name, {
                            command: menuItem.command.name,
                            group: group.name,
                            label: menuItem.label,
                            order: menuItem.order,
                            icon: undefined
                        });
                    });
                    editor.contextMenu.addListener(function (startElement, selection, path) {
                        return group.listener(startElement, selection, path);
                    });
                });
                editor.on('selectionChange', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onSelectionChange({ editor: editor });
                });
                editor.on('change', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onChange({ editor: editor, evt: event });
                });
                editor.on('key', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onSelectionChange({ editor: editor });
                    scope === null || scope === void 0 ? void 0 : scope.onKey({ editor: editor, evt: event });
                });
                editor.on('mode', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onChangeMode({ editor: editor, evt: event });
                });
                editor.on('paste', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onPaste({ editor: editor, evt: event });
                });
                editor.on('doubleclick', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onDoubleClick({ editor: editor, evt: event });
                });
                editor.on('menuShow', function (event) {
                    scope === null || scope === void 0 ? void 0 : scope.onContextMenuShow({ editor: editor, evt: event });
                    var panel = event.data[0];
                    var onHideFunc = panel.onHide;
                    panel.onHide = function () {
                        onHideFunc();
                        scope === null || scope === void 0 ? void 0 : scope.onContextMenuHide({ editor: editor, evt: event });
                    };
                });
                editor.on('maximize', function (event) {
                    scope.onMaximize({ editor: editor, evt: event });
                });
                editor.on('beforeCommandExec', function (event) {
                    scope.beforeCommandExec({ editor: editor, evt: event });
                });
                editor.dataProcessor.writer.sortAttributes = 0;
                scope === null || scope === void 0 ? void 0 : scope.onReady({ editor: editor });
            });
            var destroyOnUnreg = scope.$on('$destroy', function () {
                editor === null || editor === void 0 ? void 0 : editor.destroy();
                destroyOnUnreg();
            });
        }
    };
});
