var BrowserType;
(function (BrowserType) {
    BrowserType["Alpha"] = "Alpha";
    BrowserType["Chrome"] = "Chrome";
    BrowserType["Firefox"] = "Firefox";
    BrowserType["QTWebEngine"] = "QTWebEngine";
    BrowserType["QTWebKit"] = "QWebKit";
})(BrowserType || (BrowserType = {}));
var BrowserInfoProvider = (function () {
    function BrowserInfoProvider($window) {
        this.$window = $window;
    }
    BrowserInfoProvider.prototype.getCurrent = function () {
        var userAgent = this.$window.navigator.userAgent;
        if (userAgent.indexOf('QtWebEngine') !== -1) {
            return BrowserType.QTWebEngine;
        }
        if ((_.isDefined(this.$window.chrome) && Object.keys(this.$window.chrome).length === 0)) {
            return BrowserType.Alpha;
        }
        if (/chrome|chromium|crios/i.test(userAgent)) {
            return BrowserType.Chrome;
        }
        if ('InstallTrigger' in this.$window) {
            return BrowserType.Firefox;
        }
        if (/wccoa/i.test(userAgent)) {
            return BrowserType.QTWebKit;
        }
    };
    BrowserInfoProvider.prototype.isAlpha = function () {
        return this.getCurrent() === BrowserType.Alpha;
    };
    BrowserInfoProvider.prototype.isChrome = function () {
        return this.getCurrent() === BrowserType.Chrome;
    };
    BrowserInfoProvider.prototype.isFirefox = function () {
        return this.getCurrent() === BrowserType.Firefox;
    };
    BrowserInfoProvider.prototype.isQTWebEngine = function () {
        return this.getCurrent() === BrowserType.QTWebEngine;
    };
    BrowserInfoProvider.prototype.isQTWebKit = function () {
        return this.getCurrent() === BrowserType.QTWebKit;
    };
    BrowserInfoProvider.prototype.canPrint = function () {
        return this.isChrome() || this.isFirefox();
    };
    BrowserInfoProvider.$inject = ['$window'];
    return BrowserInfoProvider;
}());
app.service('browserInfoProvider', BrowserInfoProvider);
