var PermissionService = (function () {
    function PermissionService(authentication) {
        this.authentication = authentication;
        this.permissions = new technodoc.Permissions();
    }
    PermissionService.prototype.getAll = function () {
        return this.permissions;
    };
    PermissionService.prototype.getPermissions = function (roles) {
        return _.unique(_.flatten(_.map(roles, function (role) { return _.map(role.permissions, function (permission) { return permission.ident; }); })));
    };
    PermissionService.$inject = [
        'authentication'
    ];
    return PermissionService;
}());
app.service('permissionService', PermissionService);
angular.module('kamhpp').run(function ($rootScope) {
    $rootScope.permissions = new technodoc.Permissions();
});
