var ServiceUnavailableInterceptor = (function () {
    function ServiceUnavailableInterceptor($q, $rootScope, $injector) {
        var _this = this;
        this.$q = $q;
        this.$rootScope = $rootScope;
        this.$injector = $injector;
        this.response = function (response) {
            return response;
        };
        this.responseError = function (response) {
            if (response.status === -1 && _.isUndefined(response.config.timeout) || response.status === 503) {
                if (!_this.$rootScope.isServerUnavailableModalOpened) {
                    _this.$rootScope.isServerUnavailableModalOpened = true;
                    var modal = _this.$injector.get('$modal');
                    modal.open({
                        templateUrl: 'ng1/dist/src/ErrorPages/ServiceUnavailable/ServiceUnavailableView.html',
                        controller: 'serviceUnavailableViewCtrl',
                        windowClass: 'full-screen-diagnostic-modal',
                        backdrop: 'static',
                        keyboard: false,
                        resolve: {
                            statusCode: function () { return response.status; }
                        },
                    })
                        .result.finally(function () {
                        _this.$rootScope.isServerUnavailableModalOpened = false;
                    });
                }
            }
            return _this.$q.reject(response);
        };
    }
    ServiceUnavailableInterceptor.Factory = function ($q, $rootScope, $injector) {
        return new ServiceUnavailableInterceptor($q, $rootScope, $injector);
    };
    ServiceUnavailableInterceptor.$inject = ['$q', '$rootScope', '$injector'];
    return ServiceUnavailableInterceptor;
}());
