CREATE TABLE `UserAuthenticationTypes` (
    `Id` VARCHAR(36) PRIMARY KEY,
    `UserId` VARCHAR(255) NOT NULL,
    `Login` VARCHAR(255) NOT NULL,
    `Password` VARCHAR(255),
    `Type` INT NOT NULL,
    `IsEnabled` BOOLEAN NOT NULL DEFAULT TRUE,
    CONSTRAINT `FK_UserAuthenticationTypes_Users_UserId` FOREIGN KEY (`UserId`) REFERENCES `Users`(`Id`) ON DELETE CASCADE
);

CREATE UNIQUE INDEX `IX_UserAuthenticationTypes_Login_Type` ON `UserAuthenticationTypes` (`Login`, `Type`);

INSERT INTO `UserAuthenticationTypes` (`Id`, `UserId`, `Login`, `Password`, `Type`, `IsEnabled`)
SELECT UUID(), `Id`, `Login`, `Password`, `AuthenticationType`, TRUE
FROM `Users`;

ALTER TABLE `Users`
DROP COLUMN `Login`,
DROP COLUMN `Password`,
DROP COLUMN `AuthenticationType`,
DROP COLUMN `SigningAuthority`;