﻿CREATE TABLE [__EFMigrationsHistory] (
    [MigrationId] NVARCHAR(150) NOT NULL,
    [ProductVersion] NVARCHAR(32) NOT NULL,
    CONSTRAINT [PK___EFMigrationsHistory] PRIMARY KEY ([MigrationId])
);

CREATE TABLE [CimAttributeDataTypes] (
    [Id] [int] IDENTITY NOT NULL ,
    [Name] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_CimAttributeDataTypes] PRIMARY KEY ([Id])
);

CREATE TABLE [CimAttributeInstances] (
    [Id] INT IDENTITY NOT NULL , 
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DateTime NOT NULL,
    [EndDate] DATETIME,
    [AttributeUniqueCode] NVARCHAR(MAX),
    [ClassIstanceUniqueCode] NVARCHAR(MAX),
    [Value] NVARCHAR,
    CONSTRAINT [PK_CimAttributeInstances] PRIMARY KEY ([Id])
);
 
CREATE TABLE [CimLinkCapacities] (
    [Id] INT IDENTITY NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_CimLinkCapacities] PRIMARY KEY ([Id])
);

CREATE TABLE [CimClasses] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME,
    [Name] NVARCHAR(MAX) NOT NULL,
    [BaseClassUniqueCode] NVARCHAR(MAX),
    CONSTRAINT [PK_CimClasses] PRIMARY KEY ([Id])
);

CREATE TABLE [CimClassInstances] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ClassUniqueCode] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_CimClassInstances] PRIMARY KEY ([Id])
);

CREATE TABLE [CimDictionaryProfileSets] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX),
    CONSTRAINT [PK_CimDictionaryProfileSets] PRIMARY KEY ([Id])
);

CREATE TABLE [CimLinkInstances] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME,
    [LinkUniqueCode] NVARCHAR(MAX),
    [SourceClassInstanceUniqueCode] NVARCHAR(MAX) NOT NULL,
    [TargetClassInstanceUniqueCode] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_CimLinkInstances] PRIMARY KEY ([Id])
);

CREATE TABLE [CimLinkTypes] (
    [Id] INT IDENTITY NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_CimLinkTypes] PRIMARY KEY ([Id])
);

CREATE TABLE [CimAttributes] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ClassUniqueCode] NVARCHAR(MAX) NOT NULL,
    [DataTypeId] INT NOT NULL,
    CONSTRAINT [PK_CimAttributes] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_CimAttributes_CimAttributeDataTypes_DataTypeId] FOREIGN KEY ([DataTypeId]) REFERENCES [CimAttributeDataTypes] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [CimDictionaryProfiles] (
    [Id] uniqueidentifier NOT NULL,
    [SourceUniqueCode] NVARCHAR(MAX),
    [TargetUniqueCode] NVARCHAR(MAX),
    [LinkUniqueCode] NVARCHAR(MAX),
    [Name] NVARCHAR(MAX),
    [IsBackLink] BIT NOT NULL,
    [CreateGroupNode] BIT NOT NULL,
    [ShowRecursiveSelfLinks] BIT NOT NULL,
    [ParentId] uniqueidentifier,
    [CimDictionaryProfileId] uniqueidentifier NOT NULL,
    [CimDictionaryProfileSetId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_CimDictionaryProfiles] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_CimDictionaryProfiles_CimDictionaryProfiles_CimDictionaryPr~] FOREIGN KEY ([CimDictionaryProfileId]) REFERENCES [CimDictionaryProfiles] ([Id]),
    CONSTRAINT [FK_CimDictionaryProfiles_CimDictionaryProfileSets_CimDictionar~] FOREIGN KEY ([CimDictionaryProfileSetId]) REFERENCES [CimDictionaryProfileSets] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [CimLinks] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueCode] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [SourceClassUniqueCode] NVARCHAR(MAX) NOT NULL,
    [TargetClassUniqueCode] NVARCHAR(MAX) NOT NULL,
    [TypeId] INT NOT NULL,
    [CapacityId] INT NOT NULL,
    CONSTRAINT [PK_CimLinks] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_CimLinks_CimLinkCapacities_CapacityId] FOREIGN KEY ([CapacityId]) REFERENCES [CimLinkCapacities] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_CimLinks_CimLinkTypes_TypeId] FOREIGN KEY ([TypeId]) REFERENCES [CimLinkTypes] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [ExternalConnectionSettings] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [Type] INT NOT NULL,
    [Status] integer NOT NULL,
    [AllowableAccessErrorCount] integer NOT NULL,
    [CurrentAccessErrorCount] integer NOT NULL,
    [Json] NVARCHAR(MAX) NOT NULL,
    [LastCheckTime] DATETIME NOT NULL,
    [ReconnectionInterval] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_ExternalConnectionSettings] PRIMARY KEY ([Id])
);

CREATE TABLE [Mails] (
    [Id] NVARCHAR(128)  NOT NULL,
    [CreationTimestamp] DATETIME NOT NULL,
    [Message] VARBINARY(MAX) NOT NULL,
    [IsSent] BIT NOT NULL,
    CONSTRAINT [PK_Mails] PRIMARY KEY ([Id])
);

CREATE TABLE [OpcConnections] (
    [Id] INT IDENTITY NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [Json] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_OpcConnections] PRIMARY KEY ([Id])
);

CREATE TABLE [ReportTemplates] (
    [Id] INT IDENTITY NOT NULL,
    [UniqueGuid] uniqueidentifier NOT NULL,
    [Version] integer NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [Chapter] NVARCHAR(MAX) NOT NULL,
    [Parameters] NVARCHAR(MAX) NOT NULL,
    [Html] NVARCHAR(MAX) NOT NULL,
    [Rules] NVARCHAR(MAX) NOT NULL,
    [ContentVersion] INT NOT NULL,
    [HasStep] bit NOT NULL,
    [IsHide] bit NOT NULL,
    [PeriodStep] nvarchar(max) NULL,
    [Priority] int NOT NULL,
    [ReportType] int NOT NULL
    CONSTRAINT [PK_ReportTemplates] PRIMARY KEY ([Id])
);

CREATE TABLE [Reports] (
    [Id] INT IDENTITY NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [StartDate] DATETIME NOT NULL,
    [EndDate] DATETIME NOT NULL,
    [Values] VARBINARY(MAX) NULL,
    [RecalculationState] INT NOT NULL,
    [CalculationResult] INT NOT NULL,
    [IsCompleted] BIT NOT NULL,
    [HasIncompletedRules] BIT NOT NULL,
    [ReportTemplateUniqueGuid] uniqueidentifier NOT NULL,
    [PredefinedValuesHashCode] integer NOT NULL,
    [ReportTemplateId] INT NOT NULL,
    [ContentVersion] INT NOT NULL,
    [Changes] NVARCHAR(MAX) NULL,
    [CreatedDate] datetime2 NOT NULL,
    [CreatedUserName] nvarchar(max) NULL,
    [DependentReports] NVARCHAR(MAX) NULL,
    [UpdatedDate] datetime2 NOT NULL,
    [LockDate] datetime2 NULL,
    [PredefinedValues] NVARCHAR(MAX) NOT NULL,
    [Rules] NVARCHAR(MAX) NULL,
    CONSTRAINT [PK_Reports] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_Reports_ReportTemplates_ReportTemplateId] FOREIGN KEY ([ReportTemplateId]) REFERENCES [ReportTemplates] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [ServerSettings] (
    [Name] NVARCHAR(128) NOT NULL,
    [Value] NVARCHAR(MAX) NULL,
    CONSTRAINT [PK_ServerSettings] PRIMARY KEY ([Name])
);

CREATE TABLE [SysLogs] (
    [Id] uniqueidentifier NOT NULL,
    [ActionTime] DATETIME NOT NULL,
    [User] NVARCHAR(MAX) NOT NULL,
    [Description] NVARCHAR(MAX) NOT NULL,
    [TagValues] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_SysLogs] PRIMARY KEY ([Id])
);

CREATE TABLE [Roles] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [PermissionIdents] NVARCHAR(MAX) NOT NULL,
    [IsDomainUserGroup] BIT NOT NULL,
    CONSTRAINT [PK_Roles] PRIMARY KEY ([Id])
);

CREATE TABLE [Users] (
    [Id] uniqueidentifier NOT NULL,
    [Login] NVARCHAR(MAX) NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [Password] NVARCHAR(MAX) NOT NULL,
    [IsActive] BIT NOT NULL,
	[IsDomain] BIT NOT NULL,
    [Position] NVARCHAR(MAX) NULL,
    [Signature] VARBINARY(MAX) NULL,
    [SigningAuthority] NVARCHAR(MAX) NULL,
    CONSTRAINT [PK_Users] PRIMARY KEY ([Id])
);

CREATE TABLE [UserRoles] (
    [UserId] uniqueidentifier NOT NULL,
    [RoleId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_UserRoles] PRIMARY KEY ([UserId], [RoleId]),
    CONSTRAINT [FK_UserRoles_Roles_RoleId] FOREIGN KEY ([RoleId]) REFERENCES [Roles] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_UserRoles_Users_UserId] FOREIGN KEY ([UserId]) REFERENCES [Users] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTParameters] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(128) NOT NULL,
    [Algorithm] NVARCHAR(MAX) NOT NULL,
    CONSTRAINT [PK_OTParameters] PRIMARY KEY ([Id])
);

CREATE TABLE [OTSettings] (
    [Name] NVARCHAR(128) NOT NULL,
    [Value] NVARCHAR(MAX) NULL,
    CONSTRAINT [PK_OTSettings] PRIMARY KEY ([Name])
);

CREATE TABLE [OTAlgorithmConstants] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ParameterId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_OTAlgorithmConstants] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTAlgorithmConstants_OTParameters_ParameterId] FOREIGN KEY ([ParameterId]) REFERENCES [OTParameters] ([Id])
);

CREATE TABLE [OTAlgorithmParameters] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ParameterId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_OTAlgorithmParameters] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTAlgorithmParameters_OTParameters_ParameterId] FOREIGN KEY ([ParameterId]) REFERENCES [OTParameters] ([Id])
);

CREATE TABLE [OTDevices] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ParameterId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_OTDevices] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTDevices_OTParameters_ParameterId] FOREIGN KEY ([ParameterId]) REFERENCES [OTParameters] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTParameterStates] (
    [Id] uniqueidentifier NOT NULL,
    [Name] NVARCHAR(MAX) NOT NULL,
    [ParameterId] uniqueidentifier NOT NULL,
    [Value] INT NOT NULL,
    [LineType] INT NOT NULL,
    [BackgroundColor] INT NOT NULL,
    CONSTRAINT [PK_OTParameterStates] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTParameterStates_OTParameters_ParameterId] FOREIGN KEY ([ParameterId]) REFERENCES [OTParameters] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTAlgorithmConstantCrosses] (
    [Id] uniqueidentifier NOT NULL,
    [AlgorithmConstantId] uniqueidentifier NOT NULL,
    [DeviceId] uniqueidentifier NOT NULL,
    [Value] FLOAT NOT NULL,
    CONSTRAINT [PK_OTAlgorithmConstantCrosses] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTAlgorithmConstantCrosses_OTAlgorithmConstants_AlgorithmCo~] FOREIGN KEY ([AlgorithmConstantId]) REFERENCES [OTAlgorithmConstants] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_OTAlgorithmConstantCrosses_OTDevices_DeviceId] FOREIGN KEY ([DeviceId]) REFERENCES [OTDevices] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTAlgorithmParameterCrosses] (
    [Id] uniqueidentifier NOT NULL,
    [AlgorithmParameterId] uniqueidentifier NOT NULL,
    [DeviceId] uniqueidentifier NOT NULL,
    [Address] NVARCHAR(MAX) NULL,
    CONSTRAINT [PK_OTAlgorithmParameterCrosses] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTAlgorithmParameterCrosses_OTAlgorithmParameters_Algorithm~] FOREIGN KEY ([AlgorithmParameterId]) REFERENCES [OTAlgorithmParameters] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_OTAlgorithmParameterCrosses_OTDevices_DeviceId] FOREIGN KEY ([DeviceId]) REFERENCES [OTDevices] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTChanges] (
    [Id] INT IDENTITY NOT NULL ,
    [UserId] uniqueidentifier NOT NULL,
    [ChangeTime] DATETIME NOT NULL,
    [OldTimestamp] DATETIME NULL,
    [NewTimestamp] DATETIME NULL,
    [OldParameterStateId] uniqueidentifier NULL,
    [NewParameterStateId] uniqueidentifier NULL,
    [DeviceId] uniqueidentifier NOT NULL,
    CONSTRAINT [PK_OTChanges] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTChanges_OTDevices_DeviceId] FOREIGN KEY ([DeviceId]) REFERENCES [OTDevices] ([Id]),
    CONSTRAINT [FK_OTChanges_OTParameterStates_NewParameterStateId] FOREIGN KEY ([NewParameterStateId]) REFERENCES [OTParameterStates] ([Id]) ,
    CONSTRAINT [FK_OTChanges_OTParameterStates_OldParameterStateId] FOREIGN KEY ([OldParameterStateId]) REFERENCES [OTParameterStates] ([Id]),
    CONSTRAINT [FK_OTChanges_Users_UserId] FOREIGN KEY ([UserId]) REFERENCES [Users] ([Id]) ON DELETE CASCADE
);

CREATE TABLE [OTRecords] (
    [Id] uniqueidentifier NOT NULL,
    [StateId] uniqueidentifier NOT NULL,
    [DeviceId] uniqueidentifier NOT NULL,
    [CreatedTimeStamp] DATETIME NOT NULL,
    [CreatedUserId] uniqueidentifier NOT NULL,
    [TimeStamp] DATETIME NOT NULL,
    CONSTRAINT [PK_OTRecords] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_OTRecords_OTDevices_DeviceId] FOREIGN KEY ([DeviceId]) REFERENCES [OTDevices] ([Id]),
    CONSTRAINT [FK_OTRecords_OTParameterStates_StateId] FOREIGN KEY ([StateId]) REFERENCES [OTParameterStates] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_OTRecords_Users_CreatedUserId] FOREIGN KEY ([CreatedUserId]) REFERENCES [Users] ([Id]) ON DELETE CASCADE
);

CREATE INDEX [IX_CimAttributes_DataTypeId] ON [CimAttributes] ([DataTypeId]);

CREATE INDEX [IX_CimDictionaryProfiles_CimDictionaryProfileId] ON [CimDictionaryProfiles] ([CimDictionaryProfileId]);

CREATE INDEX [IX_CimDictionaryProfiles_CimDictionaryProfileSetId] ON [CimDictionaryProfiles] ([CimDictionaryProfileSetId]);

CREATE INDEX [IX_CimLinks_CapacityId] ON [CimLinks] ([CapacityId]);

CREATE INDEX [IX_CimLinks_TypeId] ON [CimLinks] ([TypeId]);

CREATE INDEX [IX_Reports_ReportTemplateId] ON [Reports] ([ReportTemplateId]);

CREATE UNIQUE INDEX [IX_Reports_ReportTemplateId_StartDate_EndDate] ON [Reports] ([ReportTemplateId], [StartDate], [EndDate], [PredefinedValuesHashCode]);

CREATE UNIQUE INDEX [IX_Reports_ReportTemplateUniqueGuid_StartDate_EndDate] ON [Reports] ([ReportTemplateUniqueGuid], [StartDate], [EndDate], [PredefinedValuesHashCode]);

CREATE INDEX [IX_UserRoles_RoleId] ON [UserRoles] ([RoleId]);

CREATE INDEX [IX_UserRoles_UserId] ON [UserRoles] ([UserId]);

CREATE INDEX [IX_OTAlgorithmConstantCrosses_AlgorithmConstantId] ON [OTAlgorithmConstantCrosses] ([AlgorithmConstantId]);

CREATE INDEX [IX_OTAlgorithmConstantCrosses_DeviceId] ON [OTAlgorithmConstantCrosses] ([DeviceId]);

CREATE INDEX [IX_OTAlgorithmConstants_ParameterId] ON [OTAlgorithmConstants] ([ParameterId]);
				 
CREATE INDEX [IX_OTAlgorithmParameterCrosses_AlgorithmParameterId] ON [OTAlgorithmParameterCrosses] ([AlgorithmParameterId]);
				 
CREATE INDEX [IX_OTAlgorithmParameterCrosses_DeviceId] ON [OTAlgorithmParameterCrosses] ([DeviceId]);
				 
CREATE INDEX [IX_OTAlgorithmParameters_ParameterId] ON [OTAlgorithmParameters] ([ParameterId]);
				 
CREATE INDEX [IX_OTChanges_DeviceId] ON [OTChanges] ([DeviceId]);
				 
CREATE INDEX [IX_OTChanges_NewParameterStateId] ON [OTChanges] ([NewParameterStateId]);
				 
CREATE INDEX [IX_OTChanges_OldParameterStateId] ON [OTChanges] ([OldParameterStateId]);
				 
CREATE INDEX [IX_OTChanges_UserId] ON [OTChanges] ([UserId]);
				 
CREATE INDEX [IX_OTDevices_ParameterId] ON [OTDevices] ([ParameterId]);

CREATE UNIQUE INDEX [IX_OTParameters_Name] ON [OTParameters] ([Name]);

CREATE INDEX [IX_OTParameterStates_ParameterId] ON [OTParameterStates] ([ParameterId]);

CREATE INDEX [IX_OTRecords_CreatedUserId] ON [OTRecords] ([CreatedUserId]);

CREATE UNIQUE INDEX [IX_OTRecords_DeviceId_TimeStamp] ON [OTRecords] ([DeviceId], [TimeStamp]);

CREATE INDEX [IX_OTRecords_StateId] ON [OTRecords] ([StateId]);
