PRAGMA foreign_keys=OFF;

CREATE TABLE "UserAuthenticationTypes" (
    "Id" TEXT PRIMARY KEY,
    "UserId" TEXT NOT NULL,
    "Login" TEXT NOT NULL,
    "Password" TEXT,
    "Type" INTEGER NOT NULL,
    "IsEnabled" INTEGER NOT NULL DEFAULT 1,
    CONSTRAINT "FK_UserAuthenticationTypes_Users_UserId" FOREIGN KEY("UserId") REFERENCES "Users"("Id") ON DELETE CASCADE
);

INSERT INTO "UserAuthenticationTypes" ("Id", "UserId", "Login", "Password", "Type", "IsEnabled")
SELECT
    lower(hex(randomblob(4))) || '-' ||
    lower(hex(randomblob(2))) || '-' ||
    lower(hex(randomblob(2))) || '-' ||
    lower(hex(randomblob(2))) || '-' ||
    lower(hex(randomblob(6)))  AS "Id",
    "Id" AS "UserId",
    "Login",
    "Password",
    "AuthenticationType" AS "Type",
    1 AS "IsEnabled"
FROM "Users";

DROP INDEX IF EXISTS IX_Users_Login;
ALTER TABLE "Users" DROP COLUMN "Login";
ALTER TABLE "Users" DROP COLUMN "Password";
ALTER TABLE "Users" DROP COLUMN "AuthenticationType";
ALTER TABLE "Users" DROP COLUMN "SigningAuthority";

PRAGMA foreign_keys=ON;
