var Alarm = (function () {
    function Alarm(alarm, opcSourceHdrLocal, winccoaHdrLocal) {
        var _this = this;
        this.opcSourceHdrLocal = opcSourceHdrLocal;
        this.winccoaHdrLocal = winccoaHdrLocal;
        this.id = alarm.id;
        this.name = alarm.name;
        this.commands = alarm.commands;
        this.commandText = _.map(this.commands, function (c) { return _this.getSourceDescription(c.source) + ': ' + c.tagAddress + ' = ' + c.value; });
    }
    Alarm.prototype.getSourceDescription = function (source) {
        switch (source) {
            case 0:
                return this.opcSourceHdrLocal;
            case 1:
                return this.winccoaHdrLocal;
            default:
                return '';
        }
    };
    return Alarm;
}());
var AlarmsCtrl = (function () {
    function AlarmsCtrl($scope, $modal, switchoverFormAlarmsProvider, notificationService, language) {
        var _this = this;
        this.$scope = $scope;
        this.$modal = $modal;
        this.switchoverFormAlarmsProvider = switchoverFormAlarmsProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.alarms = [];
        this.nameTextFilter = '';
        this.commandTextFilter = '';
        this.switchoverFormAlarmsProvider.getAllAlarms().then(function (alarms) {
            _this.alarms = _.map(alarms, function (a) {
                return new Alarm(a, _this.language.getElementValue('opcSourceHdr'), _this.language.getElementValue('winccoaHdr'));
            });
        });
    }
    AlarmsCtrl.prototype.createAlarm = function () {
        var _this = this;
        var alarmName = this.language.getElementValue('switchoverFormsAlarmHdr') + ' ' + (this.alarms.length + 1);
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Alarms/CreateAlarmModal/CreateAlarmModal.html',
            controller: 'createAlarmModalCtrl',
            windowClass: 'app-modal-window edit-alarms-modal modal-width-100',
            backdrop: 'static',
            resolve: {
                originalAlarm: function () {
                    return {
                        name: alarmName,
                        commands: [],
                    };
                },
                alarms: function () { return _this.alarms; },
            },
        })
            .result.then(function (alarm) {
            _this.addAlarm(alarm);
        });
    };
    AlarmsCtrl.prototype.deleteAlarm = function (alarm) {
        var _this = this;
        var selectedAlarm = alarm;
        this.switchoverFormAlarmsProvider
            .getTemplateNames(selectedAlarm.id)
            .then(function (templateNames) {
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Alarms/DeleteAlarmModal/DeleteAlarmModal.html',
                controller: 'deleteAlarmModalCtrl',
                resolve: {
                    alarm: function () { return selectedAlarm; },
                    templateNames: function () { return templateNames; },
                },
            })
                .result.then(function () {
                _this.switchoverFormAlarmsProvider
                    .deleteAlarm(selectedAlarm.id)
                    .then(function () {
                    _this.alarms = _.filter(_this.alarms, function (alarm) { return alarm.id !== selectedAlarm.id; });
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessDeleteAlarmMsg'));
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorDeleteAlarmMsg'), data);
                });
            });
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorLoadTemplatesMsg'), result);
        });
    };
    AlarmsCtrl.prototype.copyAlarm = function (alarm) {
        var copiedAlarm = angular.copy(alarm);
        copiedAlarm.id = 0;
        _.forEach(copiedAlarm.commands, function (command) {
            command.id = 0;
            command.switchoverFormCommonAlarmId = 0;
        });
        this.addAlarm(copiedAlarm);
    };
    AlarmsCtrl.prototype.editAlarm = function (alarm) {
        var _this = this;
        var selectedAlarm = alarm;
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Alarms/CreateAlarmModal/CreateAlarmModal.html',
            controller: 'createAlarmModalCtrl',
            windowClass: 'app-modal-window edit-alarms-modal modal-width-100',
            backdrop: 'static',
            resolve: {
                originalAlarm: function () {
                    return {
                        id: selectedAlarm.id,
                        name: selectedAlarm.name,
                        commands: selectedAlarm.commands,
                    };
                },
                alarms: function () { return _.filter(_this.alarms, function (alarm) { return alarm.name !== selectedAlarm.name; }); },
            },
        })
            .result.then(function (alarm) {
            _this.switchoverFormAlarmsProvider
                .updateAlarm(alarm)
                .then(function () {
                var updatedAlarm = _.find(_this.alarms, function (o) { return o.id === selectedAlarm.id; });
                var updatedAlarmId = _this.alarms.indexOf(updatedAlarm);
                if (updatedAlarmId !== -1) {
                    _this.alarms[updatedAlarmId] = new Alarm(alarm, _this.language.getElementValue('opcSourceHdr'), _this.language.getElementValue('winccoaHdr'));
                }
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessEditAlarmMsg'));
            })
                .catch(function (result) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorEditAlarmMsg'), result);
            });
        });
    };
    AlarmsCtrl.prototype.addAlarm = function (alarm) {
        var _this = this;
        this.switchoverFormAlarmsProvider
            .createAlarm(alarm)
            .then(function (alarmId) {
            alarm.id = alarmId;
            _this.alarms.push(new Alarm(alarm, _this.language.getElementValue('opcSourceHdr'), _this.language.getElementValue('winccoaHdr')));
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessCreateAlarmMsg'));
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCreateAlarmMsg'), result);
        });
    };
    AlarmsCtrl.$inject = ['$scope', '$modal', 'switchoverFormAlarmsProvider', 'notificationService', 'language'];
    return AlarmsCtrl;
}());
angular.module('kamhpp').controller('alarmsCtrl', AlarmsCtrl);
