var TypicalOperationsCtrl = (function () {
    function TypicalOperationsCtrl(scope, $modal, switchoverFormTypicalOperationsProvider, notificationService, language, $upload, clientSettings, removeHtmlFilter, removeLineBreakFilter, removeDuplicateSpacesFilter, exportService) {
        var _this = this;
        this.scope = scope;
        this.$modal = $modal;
        this.switchoverFormTypicalOperationsProvider = switchoverFormTypicalOperationsProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.removeHtmlFilter = removeHtmlFilter;
        this.removeLineBreakFilter = removeLineBreakFilter;
        this.removeDuplicateSpacesFilter = removeDuplicateSpacesFilter;
        this.exportService = exportService;
        this.operations = [];
        this.unknownTypeId = -1;
        this.watchFunctions = [];
        this.docxFileType = 6;
        this.jsonFileType = 7;
        this.exportOperations = function () {
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/ExportOperationModal/SwitchoverFormOperationExportModal.html',
                controller: 'switchoverFormOperationExportModalCtrl',
                backdrop: 'static',
                resolve: {
                    operations: function () {
                        return _.map(_this.operations, function (o) {
                            return {
                                description: o.description,
                                id: o.id,
                            };
                        });
                    },
                },
            })
                .result.then(function (result) {
                var url = '/SwitchoverFormTypicalOperationsExport/ExportToJson?operationIds=' + result.ids.toString();
                _this.exportService.export(url);
            }, function () { });
        };
        this.scope.ctrl = this;
        this.operationsFilter = {
            name: '',
            command: '',
            selectedType: -1,
            types: [
                { id: this.unknownTypeId, name: this.language.getElementValue('allTypesHdr') },
                {
                    id: 0,
                    name: this.getTypeName(0),
                },
                {
                    id: 1,
                    name: this.getTypeName(1),
                },
                {
                    id: 2,
                    name: this.getTypeName(2),
                },
            ],
        };
        this.switchoverFormTypicalOperationsProvider
            .getAllTypicalOperations()
            .then(function (operations) {
            _this.operations = operations;
            _.forEach(_this.operations, function (operation) {
                operation.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(operation.description)));
            });
        })
            .catch(function (data) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data);
        });
        this.watchFunctions.push(scope.$on('$destroy', function () {
            _.forEach(_this.watchFunctions, function (f) {
                if (!_.isUndefined(f)) {
                    f();
                }
            });
        }));
    }
    TypicalOperationsCtrl.prototype.createOperation = function () {
        var _this = this;
        var operations = this.operations;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/EditOperationModal/SwitchoverFormEditOperationModal.html',
            controller: 'SwitchoverFormTemplateEditOperationModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                operation: function () {
                    return undefined;
                },
                operations: function () {
                    return operations;
                },
                isEditable: function () {
                    return true;
                },
                isTypical: function () {
                    return true;
                }
            },
        });
        modalInstance.result.then(function (newOperation) {
            if (_.any(operations, function (op) { return op.id === newOperation.id; })) {
                _this.updateOperation(newOperation);
            }
            else {
                _this.addOperation(newOperation);
            }
        }, function () { });
    };
    TypicalOperationsCtrl.prototype.deleteOperation = function (operation) {
        var _this = this;
        var selectedOperation = operation;
        this.switchoverFormTypicalOperationsProvider
            .getTemplateNames(selectedOperation.id)
            .then(function (templateNames) {
            var modalInstance = _this.$modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/DeleteTypicalOperationModal/DeleteTypicalOperationModal.html',
                controller: 'deleteTypicalOperationModalCtrl',
                resolve: {
                    operation: function () {
                        return selectedOperation;
                    },
                    templateNames: function () {
                        return templateNames;
                    },
                },
            });
            modalInstance.result.then(function () {
                _this.switchoverFormTypicalOperationsProvider
                    .deleteTypicalOperation(selectedOperation.id)
                    .then(function () {
                    _this.operations = _.filter(_this.operations, function (operation) { return operation.id !== selectedOperation.id; });
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessDeleteOperationMsg'));
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorDeleteOperationMsg'), data);
                });
            }, function () { });
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorLoadTemplatesMsg'), result);
        });
    };
    TypicalOperationsCtrl.prototype.copyOperation = function (operation) {
        var copiedOperation = angular.copy(operation);
        copiedOperation.id = 0;
        _.forEach(copiedOperation.commands, function (command) {
            command.id = 0;
            command.switchoverFormCommonOperationId = 0;
        });
        this.addOperation(copiedOperation);
    };
    TypicalOperationsCtrl.prototype.editOperation = function (operation) {
        var _this = this;
        var operations = this.operations;
        var selectedOperation = operation;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/EditOperationModal/SwitchoverFormEditOperationModal.html',
            controller: 'SwitchoverFormTemplateEditOperationModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                operation: function () {
                    return operation;
                },
                operations: function () {
                    return _.filter(operations, function (op) { return op.description !== selectedOperation.description; });
                },
                isEditable: function () {
                    return true;
                },
                isTypical: function () {
                    return true;
                }
            },
        });
        modalInstance.result.then(function (editedOperation) {
            _this.updateOperation(editedOperation);
        }, function () { });
    };
    TypicalOperationsCtrl.prototype.filesForImportSelected = function (files, fileType) {
        var _this = this;
        if (!files || !_.any(files)) {
            return;
        }
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/ImportOperationModal/SwitchoverFormOperationImportModal.html',
            controller: 'switchoverFormOperationImportModalCtrl',
            backdrop: 'static',
            resolve: {
                contentFiles: function () { return files; },
                fileType: function () { return fileType; },
            },
        })
            .result.then(function (uploadData) {
            _this.$upload.upload(uploadData).then(function (operationsResult) {
                _.forEach(operationsResult.data, function (o) {
                    o.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(o.description)));
                    var index = _.findIndex(_this.operations, function (scopeOperation) { return scopeOperation.id === o.id; });
                    if (index === -1) {
                        _this.operations.push(o);
                    }
                    else {
                        _this.operations[index] = o;
                    }
                });
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessOperationsImportMsg'));
            }, function (errorInfo) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorOperationsImportMsg'), errorInfo);
            });
        }, function () { });
    };
    TypicalOperationsCtrl.prototype.getTypeName = function (type) {
        switch (type) {
            case 1: {
                return this.language.getElementValue('switchoverFormsAutomaticTypeMsg');
            }
            case 0: {
                return this.language.getElementValue('switchoverFormsManualTypeMsg');
            }
            case 2: {
                return this.language.getElementValue('switchoverFormsTextTypeMsg');
            }
            default: {
                return this.language.getElementValue('switchoverFormsNotSelectedEntryHdr');
            }
        }
    };
    TypicalOperationsCtrl.prototype.filterOperations = function () {
        var _this = this;
        return function (operation) {
            return ((!_this.operationsFilter.name ||
                operation.textDescription.toLowerCase().contains(_this.operationsFilter.name.toLowerCase())) &&
                (!_this.operationsFilter.command ||
                    _.any(operation.commands, function (command) {
                        return command.name.toLowerCase().contains(_this.operationsFilter.command.toLowerCase());
                    })) &&
                (_this.operationsFilter.selectedType === -1 || operation.type === _this.operationsFilter.selectedType));
        };
    };
    TypicalOperationsCtrl.prototype.getCommandsDescription = function (operation) {
        var _this = this;
        var commands = _.sortBy(operation.commands, function (c) { return c.orderNumber; });
        return _.map(commands, function (c) {
            return _this.getSourceDescription(c.source) +
                ': ' +
                c.tagAddress +
                ' = ' +
                c.value +
                ' (' +
                _this.getTypeDescription(c.type) +
                ')';
        });
    };
    TypicalOperationsCtrl.prototype.addOperation = function (operation) {
        var _this = this;
        this.switchoverFormTypicalOperationsProvider
            .createTypicalOperation(operation)
            .then(function (operationId) {
            var newOperation = operation;
            newOperation.id = operationId;
            newOperation.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(newOperation.description)));
            _this.operations.push(newOperation);
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessCreateOperationMsg'));
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCreateOperationMsg'), result);
        });
    };
    TypicalOperationsCtrl.prototype.getSourceDescription = function (source) {
        switch (source) {
            case 0:
                return this.language.getElementValue('opcSourceHdr');
            case 1:
                return this.language.getElementValue('winccoaHdr');
            default:
                return '';
        }
    };
    TypicalOperationsCtrl.prototype.getTypeDescription = function (type) {
        switch (type) {
            case 0:
                return this.language.getElementValue('switchoverFormsCommandTypeVerifyMsg');
            case 1:
                return this.language.getElementValue('switchoverFormsCommandTypeWriteMsg');
            case 2:
                return this.language.getElementValue('switchoverFormsCommandTypeVerifyBitMsg');
            case 3:
                return this.language.getElementValue('switchoverFormsCommandTypeWriteBitMsg');
            default:
                return '';
        }
    };
    TypicalOperationsCtrl.prototype.updateOperation = function (editedOperation) {
        var _this = this;
        this.switchoverFormTypicalOperationsProvider
            .updateTypicalOperation(editedOperation)
            .then(function () {
            var operation = _.find(_this.operations, function (o) { return o.id === editedOperation.id; });
            operation.description = editedOperation.description;
            operation.commands = editedOperation.commands;
            operation.type = editedOperation.type;
            operation.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(operation.description)));
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessEditOperationMsg'));
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorEditOperationMsg'), result);
        });
    };
    TypicalOperationsCtrl.$inject = [
        '$scope',
        '$modal',
        'switchoverFormTypicalOperationsProvider',
        'notificationService',
        'language',
        '$upload',
        'clientSettings',
        'removeHtmlFilter',
        'removeLineBreakFilter',
        'removeDuplicateSpacesFilter',
        'exportService',
    ];
    return TypicalOperationsCtrl;
}());
angular.module('kamhpp').controller('TypicalOperationsCtrl', TypicalOperationsCtrl);
