var SwitchoverFormTemplateTypicalConditionSelectModalCtrl = (function () {
    function SwitchoverFormTemplateTypicalConditionSelectModalCtrl($scope, modal, language, conditions) {
        this.$scope = $scope;
        this.modal = modal;
        this.language = language;
        this.conditions = conditions;
        this.unknownTypeId = -1;
        this.conditionFilter = {
            name: '',
            commandName: '',
            selectedType: this.unknownTypeId,
            types: [
                { id: this.unknownTypeId, name: language.getElementValue('allTypesHdr') },
                {
                    id: 0,
                    name: this.getTypeName(0),
                },
                {
                    id: 1,
                    name: this.getTypeName(1),
                },
                {
                    id: 2,
                    name: this.getTypeName(2),
                },
            ],
        };
        this.$scope.ctrl = this;
    }
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.selectCondition = function (condition) {
        this.selectedCondition = condition;
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.getTypeName = function (type) {
        switch (type) {
            case 1: {
                return this.language.getElementValue('switchoverFormsAutomaticTypeMsg');
            }
            case 0: {
                return this.language.getElementValue('switchoverFormsManualTypeMsg');
            }
            case 2: {
                return this.language.getElementValue('switchoverFormsTextTypeMsg');
            }
            default: {
                return this.language.getElementValue('switchoverFormsNotSelectedEntryHdr');
            }
        }
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.filterConditions = function () {
        var _this = this;
        return function (condition) { return _this.checkConditionByFilter(condition); };
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.ok = function () {
        this.modal.close(this.selectedCondition);
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.prototype.checkConditionByFilter = function (condition) {
        var check = true;
        if (this.conditionFilter.selectedType !== this.unknownTypeId) {
            check = check && condition.type === this.conditionFilter.selectedType;
        }
        if (check && this.conditionFilter.name !== '') {
            var findStr = this.conditionFilter.name
                .toUpperCase()
                .replaceAllPolyfill(' ', '')
                .replaceAllPolyfill('.', '')
                .replaceAllPolyfill('-', '');
            check =
                check &&
                    condition.description
                        .toUpperCase()
                        .replaceAllPolyfill(' ', '')
                        .replaceAllPolyfill('.', '')
                        .replaceAllPolyfill('-', '')
                        .contains(findStr);
        }
        if (check && this.conditionFilter.commandName !== '') {
            var findStr_1 = this.conditionFilter.commandName.toUpperCase();
            check =
                check &&
                    _.any(condition.commands, function (command) { return command.name.toUpperCase().contains(findStr_1); });
        }
        return check;
    };
    SwitchoverFormTemplateTypicalConditionSelectModalCtrl.$inject = ['$scope', '$modalInstance', 'language', 'conditions'];
    return SwitchoverFormTemplateTypicalConditionSelectModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('switchoverFormTemplateTypicalConditionSelectModalCtrl', SwitchoverFormTemplateTypicalConditionSelectModalCtrl);
