var SwitchoverFormPlayerProvider = (function () {
    function SwitchoverFormPlayerProvider($q, $timeout, switchoverFormProviderService, switchoverFormConfigurationProvider, notificationService, language) {
        this.$q = $q;
        this.$timeout = $timeout;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.notificationService = notificationService;
        this.language = language;
    }
    SwitchoverFormPlayerProvider.prototype.createInstance = function (switchoverForm) {
        var _this = this;
        var deferred = this.$q.defer();
        this.switchoverFormConfigurationProvider
            .getSwitchoverFormConfiguration()
            .then(function (settings) {
            deferred.resolve(new SwitchoverFormPlayer(_this.$timeout, _this.switchoverFormProviderService, _this.notificationService, _this.language, switchoverForm, settings.delayBetweenSteps, settings.isWriteCommandAutomaticExecutionAllowed));
        })
            .catch(function (error) {
            deferred.reject(error);
        });
        return deferred.promise;
    };
    SwitchoverFormPlayerProvider.$inject = [
        '$q',
        '$timeout',
        'switchoverFormProvider',
        'switchoverFormConfigurationProvider',
        'notificationService',
        'language',
    ];
    return SwitchoverFormPlayerProvider;
}());
angular.module('kamhpp').service('switchoverFormPlayerProvider', SwitchoverFormPlayerProvider);
