var AggregationSettingsCtrl = (function () {
    function AggregationSettingsCtrl(parentScope, language) {
        this.watchFunctions = [];
        this.parentScope = parentScope;
        this.language = language;
    }
    AggregationSettingsCtrl.prototype.init = function () {
        var _this = this;
        var _a;
        var _b;
        var self = this;
        this.setting = this.parentScope.param.Aggregation;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectFunctionsItem(3, this.language.getElementValue('reportParameterAggregationAvgHdr'), 'GetParameterValuesAvg', 'AggregationValue'),
            new SelectFunctionsItem(0, this.language.getElementValue('reportParameterAggregationSumHdr'), 'GetParameterValuesSum', 'AggregationValue'),
            new SelectFunctionsItem(1, this.language.getElementValue('reportParameterAggregationMaxHdr'), 'GetParameterValuesMax', 'AggregationValue'),
            new SelectFunctionsItem(2, this.language.getElementValue('reportParameterAggregationMinHdr'), 'GetParameterValuesMin', 'AggregationValue'),
        ], function (t) {
            return t.ident === self.setting.func;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.setting.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        var filteredParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (i) {
            return (i.Ident !== _this.parentScope.param.Ident &&
                (i.ParameterType === 'WinccOaValue' ||
                    i.ParameterType === 'PiramidaValue' ||
                    i.ParameterType === 'double' ||
                    i.ParameterType === 'double?' ||
                    i.ParameterType === 'int' ||
                    i.ParameterType === 'OpcValue' ||
                    i.ParameterType === 'AggregationValue'));
        });
        (_a = (_b = self.setting).sourceParameterIdent) !== null && _a !== void 0 ? _a : (_b.sourceParameterIdent = _.first(filteredParameters).Ident);
        this.reportParameters = getVariantsContainer(this.parentScope, _.map(filteredParameters, function (parameter) {
            return new UiSelectItem(parameter.Ident, parameter.Source);
        }), function (t) {
            return t.ident === self.setting.sourceParameterIdent;
        }, function (after, before) {
            if (after === before)
                return;
            self.setting.sourceParameterIdent = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.Aggregation.startPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.parentScope.param.Aggregation.startPeriod = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.Aggregation.endPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.parentScope.param.Aggregation.endPeriod = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    AggregationSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        this.reportParameters.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
    };
    AggregationSettingsCtrl.prototype.getFormula = function () {
        var _a, _b;
        var parameterIdent = _.isUndefined(this.reportParameters.selected) ? '' : this.setting.sourceParameterIdent;
        return String.Format('return {1}("%{0}%", {2}, {3});', parameterIdent, this.functions.selected.sourceFunction, (_a = this.parentScope.param.Aggregation.startPeriod) !== null && _a !== void 0 ? _a : 'null', (_b = this.parentScope.param.Aggregation.endPeriod) !== null && _b !== void 0 ? _b : 'null');
    };
    AggregationSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    AggregationSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Aggregation.canEdited();
    };
    AggregationSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Aggregation.canPlanned();
    };
    AggregationSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Aggregation.canBacklight();
    };
    AggregationSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Aggregation.canPredefined();
    };
    return AggregationSettingsCtrl;
}());
