var RandomSettingsCtrl = (function () {
    function RandomSettingsCtrl(parentScope) {
        this.watchFunctions = [];
        this.parentScope = parentScope;
    }
    RandomSettingsCtrl.prototype.init = function () {
        var _this = this;
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.RandomValue;
        }, function (randomValue) {
            if (randomValue == undefined)
                return;
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('double');
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    RandomSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
    };
    RandomSettingsCtrl.prototype.getFormula = function () {
        return ('return MathRandom(' +
            this.parentScope.param.RandomValue.MinValue +
            ', ' +
            this.parentScope.param.RandomValue.MaxValue +
            ');');
    };
    RandomSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return (!_.isNumber(this.parentScope.param.RandomValue.MinValue) ||
            !_.isNumber(this.parentScope.param.RandomValue.MaxValue) ||
            this.parentScope.param.RandomValue.MinValue > this.parentScope.param.RandomValue.MaxValue);
    };
    RandomSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.RandomValue.canEdited();
    };
    RandomSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.RandomValue.canPlanned();
    };
    RandomSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.RandomValue.canBacklight();
    };
    RandomSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.RandomValue.canPredefined();
    };
    return RandomSettingsCtrl;
}());
