var LockAction = (function () {
    function LockAction(scope, language, source) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.type = 4;
        this.watchFunction = [];
        if (source) {
            this.delay = source.delay;
        }
        else {
            this.delay = '0h';
        }
        this.language = language;
        this.refreshDisplayedDelayTimeAppliedHint();
        this.watchFunction.push(scope.$watch(function () {
            return _this.delay;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            _this.refreshDisplayedDelayTimeAppliedHint();
        }));
        this.watchFunction.push(scope.$on('$destroy', function () {
            _.forEach(_this.watchFunction, function (func) {
                if (!_.isUndefined(func)) {
                    func();
                }
            });
        }));
    }
    LockAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.delay === other.delay;
    };
    LockAction.prototype.refreshDisplayedDelayTimeAppliedHint = function () {
        var currentDay = new Date().getBeginDay();
        this.displayedDelayTimeAppliedHint = String.Format(this.language.getElementValue('reportScheduleMoveResponseTimeByHnt'), currentDay.format('dd.mm.yyyy HH:MM:ss'), dateHelper.getDatePlusTimestamp(currentDay, this.delay).format('dd.mm.yyyy HH:MM:ss'));
    };
    return LockAction;
}());
