var SendingEmailAction = (function () {
    function SendingEmailAction(scope, reportTemplateProvider, notificationService, languageService, $modal, ownerTemplateGuid, source, mailValidationService, userPreferencesService) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.notificationService = notificationService;
        this.languageService = languageService;
        this.$modal = $modal;
        this.ownerTemplateGuid = ownerTemplateGuid;
        this.mailValidationService = mailValidationService;
        this.userPreferencesService = userPreferencesService;
        this.type = 2;
        this.watchFunction = [];
        this.recipients = [''];
        this.userPreferences = userPreferencesService.getPreferences();
        this.recipients = this.userPreferences.common.mailRecipients;
        var self = this;
        if (source) {
            self.addressees = source.addressees;
            self.fileType = source.fileType;
            self.needArchive = source.needArchive;
            self.archiveFileNameTemplate = source.archiveFileNameTemplate;
            self.subject = source.subject;
            self.reportTemplateGuids = source.reportTemplateGuids;
        }
        else {
            self.addressees = [''];
            self.fileType = 1;
            self.needArchive = false;
            self.archiveFileNameTemplate = languageService.getElementValue('reportSettingsarchiveFileNameTemplateTemplatePch');
            self.subject = this.languageService.getElementValue('reportMailEmptySubjectMsg');
            self.reportTemplateGuids = [ownerTemplateGuid];
        }
        reportTemplateProvider
            .getAllReportTemplatesShortInfo()
            .then(function (reportTemplates) {
            _this.allReportTemplates = reportTemplates;
        })
            .catch(function (data) {
            notificationService.errorMessage(languageService.getElementValue('failedLoadDataServerMsg'), data);
        });
        self.exportFileTypes = getVariantsContainer(scope, [
            { name: 'PDF', ident: 1 },
            { name: 'Excel', ident: 0 },
            { name: 'HTML', ident: 2 },
            { name: 'Txt', ident: 3 },
            { name: 'Xml', ident: 4 },
            { name: 'Csv', ident: 5 },
        ], function (item) {
            return item.ident === self.fileType;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            self.fileType = after.ident;
        });
        self.watchFunction.push(scope.$watch(function () {
            return _this.addressees;
        }, function (after, before) {
            if (after === before || _.isUndefined(after) || _.isUndefined(self.addressees))
                return;
            _this.addressees = _.map(after, function (o) { return o.trim(); });
        }, true));
        self.watchFunction.push(scope.$on('$destroy', function () {
            _this.exportFileTypes.destroy();
            _.forEach(self.watchFunction, function (func) {
                if (!_.isUndefined(func)) {
                    func();
                }
            });
        }));
    }
    SendingEmailAction.prototype.addSendingReportInfo = function () {
        var _this = this;
        var reportTemplate = _.find(this.allReportTemplates, function (rt) { return rt.uniqueGuid === _this.ownerTemplateGuid; });
        this.reportTemplateGuids.push(reportTemplate.uniqueGuid);
    };
    SendingEmailAction.prototype.removeSendingReportInfo = function (index) {
        this.reportTemplateGuids.splice(index, 1);
    };
    SendingEmailAction.prototype.openSendingReportEditModal = function (index) {
        var _this = this;
        var editReportModal = this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/TemplateEdit/TemplateRules/Actions/SendingReportEditModal/SendingReportEditModal.html',
            controller: 'SendingReportEditModalCtrl',
            backdrop: 'static',
            resolve: {
                reportTemplateGuid: function () { return _this.reportTemplateGuids[index]; },
                reportTemplatesShortInfo: function () { return _this.allReportTemplates; },
            },
        });
        editReportModal.result.then(function (reportTemplateGuid) {
            _this.reportTemplateGuids[index] = reportTemplateGuid;
        }, function () { });
    };
    SendingEmailAction.prototype.getReportTemplateName = function (uniqueGuid) {
        if (this.allReportTemplates) {
            return _.find(this.allReportTemplates, function (rt) { return rt.uniqueGuid === uniqueGuid; }).name;
        }
    };
    SendingEmailAction.prototype.getErrorMessages = function () {
        var invalidAddresses = { value: [] };
        var isAddressesValid = this.mailValidationService.isAddressesValid(this.addressees, invalidAddresses);
        if (isAddressesValid) {
            this.userPreferences.common.updateMailRecipientsPreferences(_.uniq(this.addressees));
            this.userPreferencesService.setPreferences(this.userPreferences);
        }
        var emailErrorNotifications = [];
        if (!isAddressesValid) {
            emailErrorNotifications.push(new NotificationMessage(this.languageService.getElementValue('reportWrongEmailAddressMsg'), _.any(invalidAddresses.value, function (a) { return !_.isEmpty(a); })
                ? invalidAddresses.value
                : null));
        }
        if (_.isEmpty(this.addressees)) {
            emailErrorNotifications.push(new NotificationMessage(this.languageService.getElementValue('reportEmptyMailListOfRecipientsMsg')));
        }
        if (_.isEmpty(this.subject)) {
            emailErrorNotifications.push(new NotificationMessage(this.languageService.getElementValue('reportWrongMailSubjectMsg')));
        }
        if (this.needArchive && _.isEmpty(this.archiveFileNameTemplate)) {
            emailErrorNotifications.push(new NotificationMessage(this.languageService.getElementValue('reportWrongMailarchiveFileNameTemplateMsg')));
        }
        return emailErrorNotifications;
    };
    SendingEmailAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.fileType === other.fileType &&
            obj.needArchive === other.needArchive &&
            obj.archiveFileNameTemplate === other.archiveFileNameTemplate &&
            obj.subject === other.subject &&
            _.isEqual(obj.addressees, other.addressees) &&
            _.isEqual(obj.reportTemplateGuids, other.reportTemplateGuids));
    };
    return SendingEmailAction;
}());
