var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var AnotherReportEventTrigger = (function (_super) {
    __extends(AnotherReportEventTrigger, _super);
    function AnotherReportEventTrigger(scope, languageService, reportTemplateProvider, notificationService, owner, source) {
        if (source === void 0) { source = null; }
        var _this = _super.call(this, scope, languageService, source) || this;
        _this.type = 2;
        var self = _this;
        if (source) {
            self.templateUniqueGuid = source.templateUniqueGuid;
            self.startTimeShift = source.startTimeShift;
            self.reportDuration = source.reportDuration;
            self.reportModificationType = source.reportModificationType;
            self.startPointTime = source.startPointTime;
        }
        else {
            self.templateUniqueGuid = '';
            self.reportModificationType = 1;
            self.startPointTime = 0;
            self.startTimeShift = '0h';
            self.reportDuration = '1d';
        }
        reportTemplateProvider
            .getAllReportTemplatesShortInfo()
            .then(function (templatesShortInfo) {
            var templatesWithoutOwner = _.filter(templatesShortInfo, function (i) {
                return i.uniqueGuid !== owner.UniqueGuid;
            });
            _this.reportTemplates = getVariantsContainer(scope, _.map(templatesWithoutOwner, function (item) {
                return new UiSelectReportTemplate(item.uniqueGuid, item.name, item.reportType);
            }), function (t) {
                return t.ident === self.templateUniqueGuid;
            }, function (after, before) {
                if (_.isUndefined(before) && _.isUndefined(after))
                    return;
                if (_.isDefined(before) && _.isDefined(after) && after.ident === before.ident)
                    return;
                if (_.isDefined(after) && after.reportType === 0) {
                    self.reportDuration = '0d';
                }
                self.templateUniqueGuid = after.ident;
            });
        })
            .catch(function (data) {
            notificationService.errorMessage(languageService.getElementValue('failedLoadDataServerMsg'), data);
        });
        _this.timestamps = getVariantsContainer(scope, [
            new UiSelectItem(0, self.languageService.getElementValue('reportDataCreateHdr')),
            new UiSelectItem(1, self.languageService.getElementValue('reportDateReportDayHdr')),
            new UiSelectItem(2, self.languageService.getElementValue('reportDateReportMonthHdr')),
            new UiSelectItem(3, self.languageService.getElementValue('reportDateReportYearHdr')),
        ], function (t) {
            return t.ident === self.startPointTime;
        }, function (after, before) {
            if (_.isUndefined(before) && _.isUndefined(after))
                return;
            if (_.isDefined(before) && _.isDefined(after) && after.ident === before.ident)
                return;
            self.startPointTime = after.ident;
        });
        self.watchFunctions.push(scope.$on('$destroy', function () {
            _this.reportTemplates.destroy();
            _this.timestamps.destroy();
            _.forEach(self.watchFunctions, function (func) {
                if (!_.isUndefined(func)) {
                    func();
                }
            });
        }));
        return _this;
    }
    AnotherReportEventTrigger.prototype.isShowReportDuration = function () {
        return (this.reportTemplates &&
            this.reportTemplates.selected &&
            this.reportTemplates.selected.reportType === 1);
    };
    AnotherReportEventTrigger.prototype.getErrorMessages = function () {
        var _this = this;
        var template = _.find(this.reportTemplates, function (template) {
            return template.ident === _this.templateUniqueGuid;
        });
        if (_.isUndefined(template)) {
            this.templateUniqueGuid = '';
        }
        return !_.isDefined(this.templateUniqueGuid) || this.templateUniqueGuid === ''
            ? [new NotificationMessage(this.languageService.getElementValue('emptyRecalcEventMsg'))]
            : [];
    };
    AnotherReportEventTrigger.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (_super.isEqual.call(this, obj, other) &&
            obj.templateUniqueGuid === other.templateUniqueGuid &&
            obj.startTimeShift === other.startTimeShift &&
            obj.reportDuration === other.reportDuration &&
            obj.reportModificationType === other.reportModificationType &&
            obj.startPointTime === other.startPointTime);
    };
    return AnotherReportEventTrigger;
}(BaseReportEventTrigger));
