var TimestampSelectModalCtrl = (function () {
    function TimestampSelectModalCtrl($scope, modalInstance, userPreferencesService, timestamps, isFormattingEnabled) {
        var _a;
        this.$scope = $scope;
        this.modalInstance = modalInstance;
        this.userPreferencesService = userPreferencesService;
        this.timestamps = timestamps;
        this.isFormattingEnabled = isFormattingEnabled;
        this.format = '';
        this.defaultFormat = 'HH:mm dd.MM';
        this.$scope.ctrl = this;
        this.userPreferences = this.userPreferencesService.getPreferences();
        this.format = (_a = this.userPreferences.report.reportTimestampFormat) !== null && _a !== void 0 ? _a : this.defaultFormat;
        this.selectedTimestamp = this.timestamps[0];
    }
    TimestampSelectModalCtrl.prototype.onDoubleClick = function (timestamp) {
        this.selectedTimestamp = timestamp;
        this.ok();
    };
    TimestampSelectModalCtrl.prototype.isValid = function () {
        return !_.isEmpty(this.format);
    };
    TimestampSelectModalCtrl.prototype.ok = function () {
        this.userPreferences.report.reportTimestampFormat = this.format;
        this.userPreferencesService.setPreferences(this.userPreferences);
        this.modalInstance.close(this.isFormattingEnabled
            ? "".concat(this.selectedTimestamp.value, ":").concat(this.format)
            : this.selectedTimestamp.value);
    };
    TimestampSelectModalCtrl.prototype.cancel = function () {
        this.modalInstance.dismiss();
    };
    TimestampSelectModalCtrl.$inject = ['$scope', '$modalInstance', 'userPreferencesService', 'timestamps', 'isFormattingEnabled'];
    return TimestampSelectModalCtrl;
}());
app.controller('TimestampSelectModalController', TimestampSelectModalCtrl);
