var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ReportPageFormat;
(function (ReportPageFormat) {
    ReportPageFormat[ReportPageFormat["None"] = 0] = "None";
    ReportPageFormat[ReportPageFormat["Custom"] = 1] = "Custom";
    ReportPageFormat[ReportPageFormat["A3"] = 2] = "A3";
    ReportPageFormat[ReportPageFormat["A4"] = 3] = "A4";
    ReportPageFormat[ReportPageFormat["A5"] = 4] = "A5";
    ReportPageFormat[ReportPageFormat["A6"] = 5] = "A6";
})(ReportPageFormat || (ReportPageFormat = {}));
var PageFormat = (function (_super) {
    __extends(PageFormat, _super);
    function PageFormat(ident, name, size) {
        var _this = _super.call(this, ident, name) || this;
        _this.size = size;
        return _this;
    }
    return PageFormat;
}(UiSelectItem));
var ReportPageSettingsModalController = (function () {
    function ReportPageSettingsModalController(scope, modalInstance, language, reportPageSettings) {
        this.scope = scope;
        this.modalInstance = modalInstance;
        this.language = language;
        this.isLandscapeOrientation = false;
        this.pageFormats = [
            new PageFormat(ReportPageFormat.A3, this.language.getElementValue('reportPageA3FormatHdr'), new ReportPageSize(297, 420)),
            new PageFormat(ReportPageFormat.A4, this.language.getElementValue('reportPageA4FormatHdr'), new ReportPageSize(210, 297)),
            new PageFormat(ReportPageFormat.A5, this.language.getElementValue('reportPageA5FormatHdr'), new ReportPageSize(148, 210)),
            new PageFormat(ReportPageFormat.A6, this.language.getElementValue('reportPageA6FormatHdr'), new ReportPageSize(105, 148)),
            new PageFormat(ReportPageFormat.Custom, this.language.getElementValue('reportPageCustomFormatHdr'), new ReportPageSize(null, null)),
            new PageFormat(ReportPageFormat.None, this.language.getElementValue('reportPageNoneFormatHdr'), new ReportPageSize(null, null))
        ];
        this.selectedPageFormat = this.pageFormats[5];
        this.scope.ctrl = this;
        if (_.isUndefined(reportPageSettings)) {
            this.modalHdr = language.getElementValue('reportAddPageModalHdr');
            this.reportPageSettings = new ReportPageSettings(this.language.getElementValue('reportNewPageHdr'));
            this.selectedPageFormat = _.find(this.pageFormats, function (i) { return i.ident === ReportPageFormat.None; });
        }
        else {
            this.modalHdr = language.getElementValue('reportEditPageModalHdr');
            this.reportPageSettings = reportPageSettings;
            this.selectedPageFormat = this.getPageFormat(reportPageSettings.size);
            this.isLandscapeOrientation = reportPageSettings.size.width > reportPageSettings.size.height;
        }
    }
    ReportPageSettingsModalController.prototype.ok = function () {
        this.modalInstance.close(this.reportPageSettings);
    };
    ReportPageSettingsModalController.prototype.cancel = function () {
        this.modalInstance.dismiss();
    };
    ReportPageSettingsModalController.prototype.isShowPageSize = function () {
        return this.selectedPageFormat.ident === ReportPageFormat.Custom;
    };
    ReportPageSettingsModalController.prototype.isShowPageOrientation = function () {
        return this.selectedPageFormat.ident !== ReportPageFormat.None
            && this.selectedPageFormat.ident !== ReportPageFormat.Custom;
    };
    ReportPageSettingsModalController.prototype.onPageOrientationChange = function () {
        var width = this.reportPageSettings.size.width;
        var height = this.reportPageSettings.size.height;
        this.reportPageSettings.size.width = height;
        this.reportPageSettings.size.height = width;
    };
    ReportPageSettingsModalController.prototype.onPageFormatChanged = function () {
        var format = this.selectedPageFormat.ident;
        if (format === ReportPageFormat.Custom) {
            this.reportPageSettings.size = _.find(this.pageFormats, function (format) { return format.ident === ReportPageFormat.A4; }).size;
            return;
        }
        this.reportPageSettings.size = this.selectedPageFormat.size;
    };
    ReportPageSettingsModalController.prototype.getPageFormat = function (size) {
        if (_.isUndefined(size.width) && _.isUndefined(size.height)) {
            return _.find(this.pageFormats, function (format) { return format.ident === ReportPageFormat.None; });
        }
        var format = _.find(this.pageFormats, function (format) {
            return (size.width === format.size.width && size.height === format.size.height)
                || (size.width === format.size.height && size.height === format.size.width);
        });
        return format !== null && format !== void 0 ? format : _.find(this.pageFormats, function (format) { return format.ident === ReportPageFormat.Custom; });
    };
    ReportPageSettingsModalController.$inject = [
        '$scope',
        '$modalInstance',
        'language',
        'reportPage'
    ];
    return ReportPageSettingsModalController;
}());
app.controller('reportPageSettingsModalCtrl', ReportPageSettingsModalController);
