app.directive('inputTime', function () {
    return {
        require: 'ngModel',
        link: function (scope, element, attr, ngModelCtrl) {
            scope.isProcessing = false;
            scope.hours = 0;
            scope.minutes = 0;
            scope.getValueInput = function () {
                var result;
                if (!_.isDate(ngModelCtrl.$modelValue)) {
                    result = new Date();
                    result.setSeconds(0);
                }
                else {
                    result = ngModelCtrl.$modelValue;
                }
                result.setHours(scope.hours);
                result.setMinutes(scope.minutes);
                return result;
            };
            scope.getFromatedInput = function (hours, minutes) {
                return ('0' + hours.toString()).slice(-2) + ':' + ('0' + minutes.toString()).slice(-2);
            };
            var e = element[0];
            var fromUser = function (text) {
                if (scope.isProcessing) {
                    return text;
                }
                if (!text) {
                    return undefined;
                }
                scope.isProcessing = true;
                try {
                    var isNeedUpdateViewValue = false;
                    var transformedInput = text.replace(/[^0-9:]/g, '');
                    var transformedInputParts = transformedInput.split(':');
                    var hours = void 0;
                    var minutes = void 0;
                    switch (transformedInputParts.length) {
                        case 0:
                            return undefined;
                        case 1:
                            switch (transformedInputParts[0].length) {
                                case 1:
                                    hours = parseInt(transformedInputParts[0]);
                                    minutes = 0;
                                    break;
                                case 2:
                                    hours = parseInt(transformedInputParts[0]);
                                    minutes = 0;
                                    break;
                                case 3:
                                    hours = parseInt(transformedInputParts[0].substr(0, 1));
                                    minutes = parseInt(transformedInputParts[0].substr(1, 2));
                                    break;
                                default:
                                    hours = parseInt(transformedInputParts[0].substr(0, 2));
                                    minutes = parseInt(transformedInputParts[0].substr(2, 2));
                                    isNeedUpdateViewValue = true;
                                    break;
                            }
                            break;
                        default:
                            hours = parseInt(transformedInputParts[0]);
                            minutes = parseInt(transformedInputParts[1]);
                            if (transformedInputParts[0].length > 1 && transformedInputParts[1].length > 1) {
                                isNeedUpdateViewValue = true;
                            }
                            break;
                    }
                    if (_.isNaN(hours)) {
                        hours = 0;
                    }
                    if (_.isNaN(minutes)) {
                        minutes = 0;
                    }
                    if (hours < 0) {
                        hours = 0;
                    }
                    if (hours > 23) {
                        hours = 23;
                    }
                    if (minutes < 0) {
                        minutes = 0;
                    }
                    if (minutes > 59) {
                        minutes = 59;
                        isNeedUpdateViewValue = true;
                    }
                    scope.hours = hours;
                    scope.minutes = minutes;
                    var result = scope.getFromatedInput(scope.hours, scope.minutes);
                    if (isNeedUpdateViewValue) {
                        ngModelCtrl.$setViewValue(result);
                        ngModelCtrl.$render();
                    }
                    return result;
                }
                finally {
                    scope.isProcessing = false;
                }
            };
            ngModelCtrl.$parsers.push(fromUser);
            var onFocusOut = function (event) {
                var targetElement = event.relatedTarget ||
                    document.activeElement;
                if (e !== targetElement) {
                    ngModelCtrl.$modelValue = scope.getValueInput();
                    ngModelCtrl.$setViewValue(scope.getFromatedInput(scope.hours, scope.minutes));
                    ngModelCtrl.$render();
                }
            };
            if (e.addEventListener) {
                e.addEventListener('blur', onFocusOut, true);
            }
            else {
                e.attachEvent('onfocusout', onFocusOut);
            }
            var unregistrationModelValueWatch = scope.$watch(function () {
                return ngModelCtrl.$modelValue;
            }, function (newValue, oldValue) {
                if (_.isUndefined(newValue)) {
                    return;
                }
                var n = Date.parse(newValue);
                if (_.isNaN(n)) {
                    return;
                }
                var d = new Date(n);
                var h = d.getHours();
                var m = d.getMinutes();
                if (scope.hours !== h || scope.minutes !== m) {
                    scope.hours = h;
                    scope.minutes = m;
                    ngModelCtrl.$setViewValue(scope.getFromatedInput(h, m));
                    ngModelCtrl.$render();
                }
            }, true);
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                unregistrationModelValueWatch();
                unregistrationDestroyFunc();
            });
        },
    };
});
