angular.module('kamhpp').directive('onWindowResize', function ($window) {
    return {
        restrict: 'A',
        scope: {
            onWindowResize: '&',
        },
        link: function (scope) {
            var cWindow = angular.element($window);
            scope.getWindowDimensions = function () {
                return {
                    h: cWindow.height(),
                    w: cWindow.width(),
                };
            };
            scope.$watch(scope.getWindowDimensions, function (newValue, oldValue) {
                if (newValue === oldValue) {
                    return;
                }
                scope.onWindowResize({ newValue: newValue, oldValue: oldValue });
            }, true);
            cWindow.bind('resize', function () {
                scope.$apply();
            });
        },
    };
});
