angular.module('kamhpp').config([
    '$routeProvider',
    function ($routeProvider) {
        $routeProvider
            .when('/', {
            resolve: {
                factory: function ($location, coreConfigurationProvider, authentication) {
                    coreConfigurationProvider.getStartPageUrl()
                        .then(function (startPageUrl) {
                        var pageUrl = '/' + startPageUrl;
                        $location.path(pageUrl);
                    })
                        .catch(function () {
                        $location.path(authentication.isLoggedIn() ? '/home' : '/login');
                    });
                },
            },
        })
            .when('/home', {
            templateUrl: 'ng1/dist/src/Home/Home.html',
            controller: 'HomeCtrl',
            controllerAs: 'ctrl',
        })
            .when('/logout', {
            resolve: {
                factory: function (authentication) {
                    authentication.logout();
                },
            },
        })
            .when('/cimModel', {
            templateUrl: 'ng1/dist/src/CimModel/Index.html',
        })
            .when('/cimClassEditor', {
            templateUrl: 'ng1/dist/src/CimModel/ClassEditorSinglePage.html',
        })
            .when('/cimXmlRdfViewer', {
            templateUrl: 'ng1/dist/src/CimModel/XmlRdfViewer/Index.html',
        })
            .when('/cimViewer/:cameFromMainPage', {
            templateUrl: 'ng1/dist/src/CimModel/ClassViewerSinglePage.html',
        })
            .when('/cimDictionaryEditor', {
            templateUrl: 'ng1/dist/src/CimModel/DictionaryEditor/Index.html',
        })
            .when('/report-templates-view', {
            templateUrl: 'ng1/dist/src/Home/Reports/ReportTemplatesView/ReportTemplatesView.html',
            controller: 'ReportTemplatesCtrl',
            controllerAs: 'ctrl',
        })
            .when('/reports', {
            templateUrl: 'ng1/dist/src/UserDocuments/Index.html',
            controller: 'ReportViewCtrl',
            controllerAs: 'reportView',
            reloadOnSearch: false,
        })
            .when('/report-templates', {
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ReportTemplatesManagement.html',
            controllerAs: 'ctrl',
        })
            .when('/report-trends', {
            templateUrl: 'ng1/dist/src/ReportTreeViewer/Index.html',
        })
            .when('/report-formulas', {
            template: '<report-formulas></report-formulas>',
        })
            .when('/switchover-forms', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Forms/SwitchoverFormsView.html',
            controller: 'SwitchoverFormsCtrl',
            controllerAs: 'ctrl',
        })
            .when('/switchover-forms/:formId', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/View/SwitchoverFormView.html',
        })
            .when('/switchover-form-templates', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/SwitchoverFormTemplateView.html',
        })
            .when('/switchover-form-templates/:templateId', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/SwitchoverFormTemplateView.html',
        })
            .when('/switchover-form-operations', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/OperationsDirectoryView.html',
        })
            .when('/switchover-form-conditions', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/ConditionDirectoryView.html',
        })
            .when('/switchover-form-alarms', {
            templateUrl: 'ng1/dist/src/SwitchoverForms/Alarms/AlarmsDirectoryView.html',
        })
            .when('/administration/:group/:tab', {
            template: '<administration></administration>',
        })
            .when('/external-connections', {
            template: '<external-connections></external-connections>',
        })
            .when('/help', {
            templateUrl: 'ng1/dist/src/Help/Help.html',
        })
            .when('/access-denied', {
            templateUrl: 'ng1/dist/src/ErrorPages/AccessDenied/AccessDeniedView.html',
            controller: 'accessDeniedViewCtrl',
        });
    },
]);
