# Путь к текущему скрипту
SCRIPT_DIRECTORY_PATH=$(dirname $(realpath "$0"))

# Путь к корневой директории приложения
APP_DIRECTORY_PATH=$(realpath "${SCRIPT_DIRECTORY_PATH}/../..")

# Путь к исполняемому файлу приложения
APP_PATH="${APP_DIRECTORY_PATH}/bin/Sms.TechnoDoc"

# Полный путь к сервису
SERVICE_FILE_PATH="/etc/systemd/system/technodoc.service"

# Если файл есть, то не перезаписываем
if test -f "$SERVICE_FILE_PATH"; then
    echo "Service already exists."
	exit 0;
fi

# Параметры сервиса
SERVICE_CONTENT="
[Unit]
Description=TechnoDoc Server Service
# Заменить "network.target" на "postgresql.service" при использовании СУБД PostgreSQL или "mysql.service" при использовании MariaDB
After=network.target

[Service]
WorkingDirectory=${APP_DIRECTORY_PATH}
Restart=on-failure
RestartSec=5
User=${USER}
ExecStart=${APP_PATH}

[Install]
WantedBy=multi-user.target"

echo -e "$SERVICE_CONTENT" | sudo tee "$SERVICE_FILE_PATH" > /dev/null
