var UiSelectItem = (function () {
    function UiSelectItem(ident, name) {
        this.ident = ident;
        this.name = name;
    }
    return UiSelectItem;
}());
function getVariantsContainer(scope, sourse, curentSelectFn, onSelectedChanged) {
    var result = sourse;
    result.selected = _.find(result, curentSelectFn);
    var unregSelectedWatch = scope.$watch(function () {
        return result.selected;
    }, onSelectedChanged);
    result.selectChange = function (selectIdent) {
        var ident = selectIdent.trim();
        if (_.isEmpty(ident))
            return;
        result.selected = {
            name: ident,
            ident: ident,
        };
    };
    result.destroy = function () {
        unregSelectedWatch();
    };
    return result;
}
function getVariantsExtendableContainer(scope, sourse, getCurrentIdent, onSelectedChanged) {
    var result = sourse;
    var curentIdent = getCurrentIdent();
    result.selected = _.find(result, function (t) {
        return t.ident === curentIdent;
    });
    if (_.isUndefined(result.selected) && !_.isEmpty(curentIdent)) {
        result.selected = {
            name: curentIdent,
            ident: curentIdent,
        };
    }
    var unregSelectedWatch = scope.$watch(function () {
        return result.selected;
    }, onSelectedChanged);
    result.selectChange = function (selectIdent) {
        var ident = selectIdent.trim();
        if (_.isEmpty(ident))
            return;
        result.selected = {
            name: ident,
            ident: ident,
        };
    };
    result.destroy = function () {
        unregSelectedWatch();
    };
    return result;
}
function getSelectContainer(scope, items, watchItem, onSelectedItemChanged) {
    var result = [];
    for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
        var item = items_1[_i];
        result.push(item);
    }
    result.selectChange = function (selectIdent) {
        result.selected = _.find(result, function (r) { return r.ident === selectIdent; });
    };
    result.selectChange(watchItem());
    var functions = [];
    functions.push(scope.$watch(function () {
        return result.selected;
    }, onSelectedItemChanged));
    functions.push(scope.$watch(watchItem, function (after, before) {
        result.selectChange(after);
    }));
    result.destroy = function () {
        _.forEach(functions, function (func) { return func(); });
    };
    return result;
}
