var dateHelper = {
    getDatePlusTimestamp: function (date, period, minus) {
        var d = new Date(date.getTime());
        if (period.indexOf('s') !== -1) {
            var seconds = +period.replace('s', '');
            if (minus)
                d.setSeconds(d.getSeconds() - seconds);
            else
                d.setSeconds(d.getSeconds() + seconds);
        }
        else if (period.indexOf('m') !== -1) {
            var minutes = +period.replace('m', '');
            if (minus)
                d.setMinutes(d.getMinutes() - minutes);
            else
                d.setMinutes(d.getMinutes() + minutes);
        }
        else if (period.indexOf('h') !== -1) {
            var hours = +period.replace('h', '');
            if (minus)
                d.setHours(d.getHours() - hours);
            else
                d.setHours(d.getHours() + hours);
        }
        else if (period.indexOf('d') !== -1) {
            var days = +period.replace('d', '');
            if (minus)
                d.setDate(d.getDate() - days);
            else
                d.setDate(d.getDate() + days);
        }
        else if (period.indexOf('w') !== -1) {
            var weks = +period.replace('w', '');
            if (minus)
                d.setDate(d.getDate() - 7 * weks);
            else
                d.setDate(d.getDate() + 7 * weks);
        }
        else if (period.indexOf('M') !== -1) {
            var months = +period.replace('M', '');
            if (minus)
                d.setMonth(d.getMonth() - months);
            else
                d.setMonth(d.getMonth() + months);
        }
        else if (period.indexOf('y') !== -1) {
            var years = +period.replace('y', '');
            if (minus)
                d.setFullYear(d.getFullYear() - years);
            else
                d.setFullYear(d.getFullYear() + years);
        }
        else {
            d.setDate(d.getDate() - 1);
        }
        return d;
    },
    getNextDate: function (period, periodShift) {
        var date;
        var periodLength = period.length;
        var periodNumber = parseFloat(period.substring(0, periodLength - 1));
        var periodType = period.substring(periodLength - 1, periodLength);
        switch (periodType) {
            case 'm':
                date = Date.getToday();
                break;
            case 'h':
                date = Date.getToday();
                break;
            case 'd':
                date = Date.getToday();
                break;
            case 'w':
                date = Date.getToday().getBeginWeek();
                break;
            case 'M':
                date = Date.getToday().getBeginMonth();
                break;
            case 'y':
                date = Date.getToday().getBeginYear();
                break;
        }
        var periodOffsetLength = periodShift.length;
        var periodOffsetType = periodShift.substring(periodOffsetLength - 1, periodOffsetLength);
        var periodOffsetValue = periodShift.substring(0, periodOffsetLength - 1);
        if (periodOffsetValue === '-') {
            periodOffsetValue = '-1';
        }
        if (periodOffsetValue === '') {
            periodOffsetValue = '0';
        }
        var periodOffsetNumber = parseFloat(periodOffsetValue);
        var plusPeriod = function (date, offsetType, offset) {
            switch (offsetType) {
                case 'm':
                    return date.addMinutes(offset);
                case 'h':
                    return date.addHours(offset);
                case 'd':
                    return date.addDays(offset);
                case 'w':
                    return date.addWeeks(offset);
                case 'M':
                    return date.addMonths(offset);
                case 'y':
                    return date.addYears(offset);
            }
        };
        date = plusPeriod(date, periodOffsetType, periodOffsetNumber);
        if (periodNumber === 0 || _.isNaN(periodNumber))
            return date;
        while (date.getTime() < Date.now()) {
            date = plusPeriod(date, periodType, periodNumber);
        }
        return date;
    },
    getMaxTimestamp: function () {
        return new Date(9999, 12, 31, 23, 59, 59);
    },
    getTimespan: function (period) {
        var result = new Date(0);
        if (_.isUndefined(period)) {
            return result;
        }
        var numericValue = Number.parseFloat(period.replace(/^\D+/g, ''));
        if (period.toLowerCase().indexOf('s') > -1) {
            return result.addSeconds(numericValue);
        }
        if (period.indexOf('m') > -1) {
            return result.addMinutes(numericValue);
        }
        if (period.toLocaleLowerCase().indexOf('h') > -1) {
            return result.addHours(numericValue);
        }
        if (period.toLocaleLowerCase().indexOf('d') > -1) {
            return result.addDays(numericValue);
        }
        if (period.indexOf('M') > -1) {
            return result.addMonths(numericValue);
        }
        if (period.indexOf('y') > -1) {
            return result.addYears(numericValue);
        }
        return result;
    }
};
