let inflightPromise = null;
let ports = [];

onconnect = (e) => {
  const port = e.ports[0];
  ports.push(port);

  port.onmessage = (event) => {
    const { type, accessToken } = event.data;

    if (type === 'refresh') {
      if (!inflightPromise) {
        inflightPromise = doRefreshToken(accessToken)
          .then(data => {
            broadcast({ type: 'done', token: data });
          })
          .catch((err) => {
            broadcast({ type: 'error', error: err });
          })
          .finally(() => {
            inflightPromise = null;
          });
      }
    }
  };

  port.start();
};

function broadcast(msg) {
  for (const p of ports) {
    try
    {
      p.postMessage(msg);
    }
    catch
    {
      // вкладка была закрыта
    }
  }
}

async function doRefreshToken(accessToken) {
    const res = await fetch('/api/Authentication/RefreshTokens', {
      method: 'POST',
      credentials: 'include',
      headers: {
        'Authorization': `Bearer ${accessToken}`,
        'Content-Type': 'application/json'
      }
    });

    if (!res.ok) {
      return Promise.reject('Refresh token failed');
    }

    return await res.text();
}
