var ExternalConnectionSelectorComponent = (function () {
    function ExternalConnectionSelectorComponent() {
        this.bindings = {
            guid: '=',
            title: '@',
            hint: '@',
            types: '<',
            filter: '&?',
            onInit: '&?',
            onSelected: '&?',
            onChanged: '&?',
        };
        this.templateUrl = 'ng1/dist/src/ExternalConnections/Common/Components/ExternalConnectionSelector.html';
        this.controller = ExternalConnectionSelectorController;
        this.controllerAs = 'ctrl';
    }
    return ExternalConnectionSelectorComponent;
}());
var ExternalConnectionSelectorController = (function () {
    function ExternalConnectionSelectorController(timeout, externalConnectionsProvider, notificationService, language) {
        this.timeout = timeout;
        this.externalConnectionsProvider = externalConnectionsProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.connections = [];
        this.types = [];
        this.filter = null;
    }
    ExternalConnectionSelectorController.prototype.$onInit = function () {
        if (_.isUndefined(this.title)) {
            this.title = this.language.getElementValue('externalConnectionHdr');
        }
    };
    ExternalConnectionSelectorController.prototype.$onChanges = function (onChangesObj) {
        var _this = this;
        var types = onChangesObj["types"];
        if (types && !_.isEqual(types.currentValue, types.previousValue)) {
            if (_.isArray(types.previousValue)) {
                if (this.connection && !_.find(types.currentValue, function (type) { return type === _this.connection.type; })) {
                    this.resetCurrentConnection();
                }
            }
            else {
                this.resetCurrentConnection();
            }
            if (!_.isEmpty(types.previousValue) || this.connections.length == 0) {
                this.loadConnections();
            }
        }
    };
    ExternalConnectionSelectorController.prototype.onConnectionSelected = function (connection) {
        var _this = this;
        if (this.guid !== connection.id) {
            if (this.onChanged) {
                this.onChanged({ connection: connection });
            }
        }
        this.guid = connection.id;
        this.timeout(function () {
            if (_this.onSelected) {
                _this.onSelected({ connection: connection });
            }
        });
    };
    ExternalConnectionSelectorController.prototype.filterConnections = function () {
        var _this = this;
        return function (connection) {
            if (!connection) {
                return false;
            }
            return _this.filter
                ? _this.filter({ connection: connection })
                : true;
        };
    };
    ExternalConnectionSelectorController.prototype.loadConnections = function () {
        var _this = this;
        if (_.isUndefined(this.types)) {
            return;
        }
        this.externalConnectionsProvider.get(this.types.toString()).then(function (connections) {
            _this.connections = connections;
            if (!_.isEmpty(_this.connections)) {
                _this.connection = _.find(_this.connections, function (connection) { return connection.id == _this.guid; });
                if (_.isDefined(_this.connection)) {
                    _this.onConnectionSelected(_this.connection);
                }
            }
            if (_this.onInit) {
                _this.onInit({ connections: connections });
            }
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ExternalConnectionSelectorController.prototype.resetCurrentConnection = function () {
        this.connection = null;
    };
    ExternalConnectionSelectorController.$inject = ['$timeout', 'externalConnectionsProvider', 'notificationService', 'language'];
    return ExternalConnectionSelectorController;
}());
angular.module('kamhpp').component('externalConnectionSelector', new ExternalConnectionSelectorComponent());
