var WinccOaConnectionCtrl = (function () {
    function WinccOaConnectionCtrl(language) {
        this.language = language;
        this.protocols = [
            { id: 0, name: 'HTTP' },
            { id: 1, name: 'XMLRPC' }
        ];
        this.periods = [
            {
                periodValue: 's',
                periodName: this.language.getElementValue('smsTimespanSecondHdr'),
            },
            {
                periodValue: 'm',
                periodName: this.language.getElementValue('smsTimespanMinuteHdr'),
            },
            {
                periodValue: 'h',
                periodName: this.language.getElementValue('smsTimespanHourHdr'),
            },
            {
                periodValue: 'd',
                periodName: this.language.getElementValue('smsTimespanDayHdr'),
            }
        ];
    }
    WinccOaConnectionCtrl.prototype.init = function () { };
    WinccOaConnectionCtrl.prototype.destroy = function () { };
    WinccOaConnectionCtrl.prototype.isXmlRpcProtocol = function (protocol) {
        return protocol === 1;
    };
    return WinccOaConnectionCtrl;
}());
