var CreateAlarmModalCtrl = (function () {
    function CreateAlarmModalCtrl($scope, $modalInstance, modalService, switchoverFormConfigurationProvider, notificationService, originalAlarm, alarms, language) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.modalService = modalService;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.notificationService = notificationService;
        this.originalAlarm = originalAlarm;
        this.alarms = alarms;
        this.language = language;
        this.commandSources = [
            { id: 1, name: this.language.getElementValue('winccoaHdr') },
            { id: 0, name: this.language.getElementValue('opcSourceHdr') }
        ];
        this.opcConnectionGuid = '';
        this.winccOaConnectionGuid = '';
        this.$scope.ctrl = this;
        this.alarm = angular.copy(originalAlarm);
        this.switchoverFormConfigurationProvider
            .getSwitchoverFormConfiguration()
            .then(function (data) {
            _this.opcConnectionGuid = data.opcConnectionGuid;
            _this.winccOaConnectionGuid = data.winccOaConnectionGuid;
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), result);
        });
    }
    CreateAlarmModalCtrl.prototype.ok = function () {
        var _this = this;
        _.any(this.alarms, function (alarm) { return alarm.name === _this.alarm.name; })
            ? this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsAlarmAlreadyExistsMsg'))
            : this.$modalInstance.close(this.alarm);
    };
    CreateAlarmModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    CreateAlarmModalCtrl.prototype.insert = function () {
        var _this = this;
        var source = !_.isEmpty(this.winccOaConnectionGuid)
            ? 1
            : 0;
        var tagTreeTypes = source === 1
            ? [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara]
            : [TagTreeType.Opc];
        var connectionGuid = source === 1
            ? this.winccOaConnectionGuid
            : this.opcConnectionGuid;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return true; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return undefined; },
            },
        });
        modalInstance.result.then(function (tags) {
            var _a;
            var commands = _.map(tags, function (tag) {
                return {
                    id: 0,
                    name: tag.name,
                    source: source,
                    tagAddress: tag.address,
                    value: '1',
                    switchoverFormCommonAlarmId: _this.alarm.id,
                };
            });
            (_a = _this.alarm.commands).push.apply(_a, commands);
        });
    };
    CreateAlarmModalCtrl.prototype.remove = function (index) {
        if (this.alarm.commands.length === 1) {
            return;
        }
        this.alarm.commands.splice(index, 1);
    };
    CreateAlarmModalCtrl.prototype.isTagExists = function (command) {
        var _this = this;
        this.switchoverFormConfigurationProvider
            .isTagExists(command.tagAddress, command.source)
            .then(function (data) {
            if (data) {
                _this.notificationService.showMessage(_this.language.getElementValue('tagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('tagAddressIsNotExistMsg'));
            }
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('errorCheckTagAddressMsg'), result);
        });
    };
    CreateAlarmModalCtrl.prototype.selectTag = function (command) {
        var tagTreeTypes = command.source === 0
            ? [TagTreeType.Opc]
            : [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara];
        var connectionGuid = command.source === 0
            ? this.opcConnectionGuid
            : this.winccOaConnectionGuid;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return command.tagAddress; },
            },
        });
        modalInstance.result.then(function (tags) {
            command.name = tags[0].name;
            command.tagAddress = tags[0].address;
        });
    };
    CreateAlarmModalCtrl.prototype.isWinccOaSource = function (commandSource) {
        return commandSource === 1;
    };
    CreateAlarmModalCtrl.prototype.disableSaveBtn = function () {
        return (this.alarm.name === '' ||
            this.alarm.commands.length === 0 ||
            _.any(this.alarm.commands, function (command) { return command.tagAddress === ''; }));
    };
    CreateAlarmModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        '$modal',
        'switchoverFormConfigurationProvider',
        'notificationService',
        'originalAlarm',
        'alarms',
        'language',
    ];
    return CreateAlarmModalCtrl;
}());
angular.module('kamhpp').controller('createAlarmModalCtrl', CreateAlarmModalCtrl);
