var CreateSwitchoverFormTemplateModalCtrl = (function () {
    function CreateSwitchoverFormTemplateModalCtrl(scope, modal, switchoverFormTemplateProviderService, notificationService, language, templateName, chapter, chapters, isCopy) {
        this.scope = scope;
        this.modal = modal;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.notificationService = notificationService;
        this.language = language;
        this.scope.ctrl = this;
        this.templateName = templateName;
        this.chapter = chapter;
        this.chapters = chapters;
        this.isCopy = isCopy;
    }
    CreateSwitchoverFormTemplateModalCtrl.prototype.ok = function () {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .isExists(this.templateName)
            .then(function (isTemplateExists) {
            if (isTemplateExists) {
                _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsTemplateAlreadyExistsMsg'), _this.templateName));
            }
            else {
                _this.modal.close({
                    templateName: _this.templateName,
                    chapterName: _this.chapter,
                });
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    CreateSwitchoverFormTemplateModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    CreateSwitchoverFormTemplateModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'switchoverFormTemplateProvider',
        'notificationService',
        'language',
        'templateName',
        'chapter',
        'chapters',
        'isCopy',
    ];
    return CreateSwitchoverFormTemplateModalCtrl;
}());
angular.module('kamhpp').controller('createSwitchoverFormTemplateModalCtrl', CreateSwitchoverFormTemplateModalCtrl);
