var SwitchoverFormTemplateCtrl = (function () {
    function SwitchoverFormTemplateCtrl($rootScope, scope, routeParams, location, modal, $q, upload, authentication, language, switchoverFormService, switchoverFormTemplateProviderService, switchoverFormTemplateAttachmentProviderService, switchoverFormTypicalOperationsProviderService, switchoverFormTypicalConditionsProviderService, switchoverFormAlarmsProviderService, switchoverFormsCkeditorConfigurationProvider, notificationService, mailProvider, browserInfoProvider, exportService, printService) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.scope = scope;
        this.routeParams = routeParams;
        this.location = location;
        this.modal = modal;
        this.$q = $q;
        this.upload = upload;
        this.authentication = authentication;
        this.language = language;
        this.switchoverFormService = switchoverFormService;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.switchoverFormTemplateAttachmentProviderService = switchoverFormTemplateAttachmentProviderService;
        this.switchoverFormTypicalOperationsProviderService = switchoverFormTypicalOperationsProviderService;
        this.switchoverFormTypicalConditionsProviderService = switchoverFormTypicalConditionsProviderService;
        this.switchoverFormAlarmsProviderService = switchoverFormAlarmsProviderService;
        this.switchoverFormsCkeditorConfigurationProvider = switchoverFormsCkeditorConfigurationProvider;
        this.notificationService = notificationService;
        this.mailProvider = mailProvider;
        this.browserInfoProvider = browserInfoProvider;
        this.exportService = exportService;
        this.printService = printService;
        this.ckeditorToolbarId = 'floatCkeditorToolbar';
        this.sidebarElementId = 'sidebar';
        this.templateBodyElementId = 'templateBody';
        this.templatesListElementId = 'templatesList';
        this.templateContainerElementId = 'templateContainer';
        this.templateListToolPanelId = 'templateListToolPanel';
        this.templateBodyElementClass = '.switchover-form-template-body';
        this.typicalOperations = null;
        this.typicalConditions = null;
        this.alarms = null;
        this.scrollToTemplate = false;
        this.isTemplatesSideMenuOpened = true;
        this.defaultSidebarWidth = '325px';
        this.defaultTemplateContainerMarginLeftWidth = '325px';
        this.templateTreeNodeIdPrefix = 'templateNode';
        this.chaptersSeparator = '/';
        this.rootTemplatesTreeNodeId = '#';
        this.chapters = [];
        this.templatesTree = new SmsTree();
        this.treeSettings = new SmsTreeSettings([new SmsTreeColumn(this.language.getElementValue('switchoverFormTemplatesListHdr'), 'Name')], null, $.jstree.defaults.core.themes, new SmsTypes('glyphicon glyphicon-none', 'fa fa-folder', 'fa fa-file-o', 'fa fa-exclamation-triangle', 'fa fa-exclamation-triangle'), ['types', 'wholerow', 'grid', 'state', 'search', 'sort'], 0, null, true, null);
        this.getUniqueName = function (names, name) {
            var i = 1;
            while (names.indexOf(name + ' ' + i) !== -1) {
                i++;
            }
            return name + ' ' + i;
        };
        this.scope.ctrl = this;
        var watchFunctions = [];
        this.stepReadOnlyEditorConfiguration =
            this.switchoverFormsCkeditorConfigurationProvider.getStepReadOnlyEditorConfiguration();
        this.stepEditorConfiguration = this.switchoverFormsCkeditorConfigurationProvider.getStepEditorConfiguration();
        this.editorConfiguration = switchoverFormsCkeditorConfigurationProvider.getEditorConfiguration();
        this.editorConfiguration.config.sharedSpaces = {
            top: this.ckeditorToolbarId,
        };
        this.templateBodyElement = angular.element(this.templateBodyElementClass);
        watchFunctions.push(scope.$on('ckInstanceEditorGetFocus', function (event, editor) {
            _this.editableEditor = editor;
            var toolbarElement = _this.getCustomToolbarJqueryElement();
            toolbarElement.css({
                display: '',
            });
            _this.calculateCkeditorToolbarPosition();
        }));
        watchFunctions.push(scope.$on('ckInstanceEditorLostFocus', function () {
            if (_this.editableEditor) {
                var toolbarElement = _this.getCustomToolbarJqueryElement();
                toolbarElement.css({
                    display: 'none',
                    position: 'absolute',
                    top: '',
                    left: '',
                });
                _this.editableEditor = null;
            }
        }));
        watchFunctions.push(scope.$watch(function () { return angular.element('#' + _this.templateBodyElementId).is(':visible'); }, function () {
            _this.calculateTemplateBodyBlockHeight();
        }));
        watchFunctions.push(scope.$watch(function () { return angular.element('#' + _this.templateListToolPanelId).is(':visible'); }, function () {
            _this.calculateTemplatesListBlockHeight();
        }));
        watchFunctions.push(this.$rootScope.$on('$locationChangeStart', function (event, next) {
            if (_.isEqual(_this.selectedTemplate, _this.originalTemplate)) {
                return;
            }
            var modalInstance = _this.modal.open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
                controller: 'yesNoCancelModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('switchoverFormsHdr'); },
                    body: function () {
                        return String.Format(_this.language.getElementValue('switchoverFormsSaveChangesHdr'), _this.selectedTemplate.name);
                    },
                },
            });
            var newUrl = _this.location.url();
            event.preventDefault();
            modalInstance.result.then(function (data) {
                if (data === 'ok') {
                    _this.save().then(function () {
                        _this.location.url(newUrl);
                    });
                }
                if (data === 'no') {
                    _this.selectedTemplate = new SwitchoverFormTemplate(_this.originalTemplate);
                    _this.location.url(newUrl);
                }
            }, function () { });
        }));
        watchFunctions.push(scope.$on('jstreeReady', function (event, treeId) {
            if (_this.templatesTree.element.attr('id') === treeId) {
                _this.switchoverFormTemplateProviderService
                    .getAllSwitchoverFormTemplatesShortInfoWithIsTypical()
                    .then(function (templates) {
                    var nodes = [];
                    _.forEach(templates, function (template) {
                        var isTemplateExists = function (currentNode) {
                            return _.isDefined(_.find(nodes, function (node) { return node.id === currentNode.id && node.parent === currentNode.parent; }));
                        };
                        _this.addNewSwitchoverTemplateTreeNodesFromTemplateInfo(template, isTemplateExists, nodes);
                        if (!_.contains(_this.chapters, template.chapterName)) {
                            _this.chapters.push(template.chapterName);
                        }
                    });
                    _this.templatesTree.element.jstree().settings.core.data = nodes;
                    _this.templatesTree.element.jstree().refresh(false, true);
                    if (!angular.isUndefined(_this.routeParams.templateId)) {
                        var templateId_1 = parseInt(_this.routeParams.templateId);
                        var template = _.find(nodes, function (node) { return !_.isEmpty(node.data) && node.data.id === templateId_1; });
                        if (template) {
                            _this.scrollToTemplate = true;
                            _this.selectTemplate(template.data);
                            _this.calculateTemplatesListBlockHeight();
                        }
                    }
                })
                    .catch(function (error) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorLoadTemplates'), error);
                });
            }
        }));
        watchFunctions.push(scope.$on('jstreeRefresh', function (event) {
            if (_this.selectedTemplateShortInfo) {
                _this.templatesTree.element
                    .jstree()
                    .select_node(_this.templateTreeNodeIdPrefix + _this.selectedTemplateShortInfo.id);
                _this.scrollToSelectedTemplate();
            }
            else {
                var getFirstLeaf_1 = function (id) {
                    var node = _this.templatesTree.element.jstree().get_node(id);
                    return node.children.length > 0
                        ? getFirstLeaf_1(node.children[0])
                        : _this.templatesTree.element.jstree().select_node(id);
                };
                getFirstLeaf_1('#');
            }
        }));
        watchFunctions.push(scope.$on('jstreeSelectNode', function (event, data) {
            var node = _this.templatesTree.element.jstree().get_node(data.id ? data.id : data);
            if (node &&
                node.data &&
                (!_this.selectedTemplateShortInfo || _this.selectedTemplateShortInfo.id !== node.data.id)) {
                _this.selectTemplate(node.data);
            }
            if (_this.selectedTemplateShortInfo && _this.scrollToTemplate) {
                _this.scrollToSelectedTemplate();
                _this.scrollToTemplate = false;
            }
            var selectedElement = _this.templatesTree.element.find('.jstree-wholerow-clicked');
            selectedElement.css('height', selectedElement.parent().children('a.jstree-anchor').height() + 'px');
        }));
        watchFunctions.push(scope.$on('jstreeHoverNode', function (event) {
            var hoveredElement = _this.templatesTree.element.find('.jstree-wholerow-hovered');
            hoveredElement.css('height', hoveredElement.parent().children('a.jstree-anchor').height() + 'px');
        }));
        this.templateBodyElement.scroll({ ctrl: this }, function (event) {
            if (event.data.ctrl && event.data.ctrl.editableEditor) {
                event.data.ctrl.calculateCkeditorToolbarPosition();
            }
        });
        this.mailProvider
            .isMailEnabled()
            .then(function (isEnable) {
            _this.isEnable = isEnable;
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
        scope.$on('$destroy', function () {
            _.forEach(watchFunctions, function (func) {
                if (func) {
                    func();
                }
            });
        });
        if (!_.isUndefined(this.routeParams.openTemplatesList)) {
            this.isTemplatesSideMenuOpened = this.routeParams.openTemplatesList;
            if (!this.isTemplatesSideMenuOpened) {
                this.defaultSidebarWidth = '40px';
                this.defaultTemplateContainerMarginLeftWidth = '40px';
            }
        }
        angular.element(document).ready(function () {
            _this.calculateBlocksHeight();
        });
    }
    SwitchoverFormTemplateCtrl.prototype.searchTemplate = function (templateName) {
        this.templatesTree.element.jstree().search(templateName, true, true, false, false, true);
    };
    SwitchoverFormTemplateCtrl.prototype.toggleSidebar = function () {
        var sidebarId = '#' + this.sidebarElementId;
        var templateContainerId = '#' + this.templateContainerElementId;
        if (this.isTemplatesSideMenuOpened) {
            angular.element(sidebarId).animate({ width: 40 }, { duration: 200, queue: false });
            angular.element(templateContainerId).animate({ 'margin-left': 40 }, { duration: 200, queue: false });
        }
        else {
            angular.element(sidebarId).animate({ width: 325 }, { duration: 200, queue: false });
            angular.element(templateContainerId).animate({ 'margin-left': 325 }, { duration: 200, queue: false });
        }
        this.isTemplatesSideMenuOpened = !this.isTemplatesSideMenuOpened;
    };
    SwitchoverFormTemplateCtrl.prototype.scrollTemplateBodyToBlock = function (blockId) {
        var templateBodyElement = angular.element('#' + this.templateBodyElementId);
        templateBodyElement.scrollTop(templateBodyElement.scrollTop() + (angular.element(blockId).offset().top - templateBodyElement.offset().top));
    };
    SwitchoverFormTemplateCtrl.prototype.toggleTableRows = function (condition) {
        angular.element(condition).toggle();
    };
    SwitchoverFormTemplateCtrl.prototype.onWindowResize = function (arg) {
        this.calculateBlocksHeight();
    };
    SwitchoverFormTemplateCtrl.prototype.selectTemplate = function (template) {
        var _this = this;
        if (!this.selectedTemplate || _.isEqual(this.selectedTemplate, this.originalTemplate)) {
            this.loadTemplate(template);
            return;
        }
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
            controller: 'yesNoCancelModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('switchoverFormsHdr'); },
                body: function () {
                    return String.Format(_this.language.getElementValue('switchoverFormsSaveChangesHdr'), _this.selectedTemplate.name);
                },
            },
        });
        modalInstance.result.then(function (data) {
            if (data === 'ok') {
                _this.save().then(function () {
                    _.defer(function () { return _this.loadTemplate(template); });
                });
            }
            if (data === 'no') {
                _this.selectedTemplate = new SwitchoverFormTemplate(_this.originalTemplate);
                _.defer(function () { return _this.loadTemplate(template); });
            }
            if (data === 'cancel') {
                _this.templatesTree.element.jstree().deselect_all();
                _this.templatesTree.element
                    .jstree()
                    .select_node(_this.templateTreeNodeIdPrefix + _this.originalTemplate.id);
            }
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.createTemplate = function () {
        var _this = this;
        var templates = this.getTemplatesShortInfo();
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/CreateTemplateModal/CreateSwitchoverFormTemplateModal.html',
            controller: 'createSwitchoverFormTemplateModalCtrl',
            backdrop: 'static',
            resolve: {
                templateName: function () {
                    return _this.getUniqueName(_.map(templates, function (t) { return t.name; }), _this.language.getElementValue('reportNewTemplateHdr'));
                },
                chapter: function () {
                    return _.isEmpty(_this.chapters)
                        ? _this.language.getElementValue('withoutSectionMsg')
                        : _.first(_this.chapters);
                },
                chapters: function () { return _this.chapters; },
                isCopy: function () { return false; },
            },
        });
        modalInstance.result.then(function (createTemplateInfo) {
            _this.switchoverFormTemplateProviderService
                .create(createTemplateInfo.templateName, createTemplateInfo.chapterName)
                .then(function (template) {
                var newTemplate = template;
                var templateTreeNode = _this.createNewJsTreeNodesFromTemplateInfo(newTemplate);
                _this.templatesTree.element.jstree().deselect_all(true);
                _this.templatesTree.element.jstree().select_node(templateTreeNode);
                if (!_.contains(_this.chapters, template.chapterName)) {
                    _this.chapters.push(template.chapterName);
                }
            })
                .catch(function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), data);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.copyTemplate = function () {
        var _this = this;
        if (!_.isEqual(this.selectedTemplate, this.originalTemplate)) {
            var modalInstance = this.modal.open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
                controller: 'yesNoCancelModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('switchoverFormsHdr'); },
                    body: function () {
                        return String.Format(_this.language.getElementValue('switchoverFormsSaveChangesHdr'), _this.selectedTemplate.name);
                    },
                },
            });
            modalInstance.result.then(function (data) {
                if (data === 'ok') {
                    _this.save().then(function () {
                        _.defer(function () { return _this.createCopyOfSelectedTemplate(); });
                    });
                }
                if (data === 'no') {
                    _this.selectedTemplate = new SwitchoverFormTemplate(_this.originalTemplate);
                    _.defer(function () { return _this.createCopyOfSelectedTemplate(); });
                }
            }, function () { });
        }
        else {
            this.createCopyOfSelectedTemplate();
        }
    };
    SwitchoverFormTemplateCtrl.prototype.deleteTemplate = function () {
        var _this = this;
        var modalHeader = this.language.getElementValue('switchoverFormsDeleteTemplateHdr');
        var modalBody = String.Format(this.language.getElementValue('switchoverFormsDeleteTemplateQuestionsHdr'), this.selectedTemplateShortInfo.name);
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return modalHeader; },
                body: function () { return modalBody; },
            },
        });
        modalInstance.result.then(function () {
            _this.switchoverFormTemplateProviderService
                .delete(_this.selectedTemplateShortInfo.id, _this.selectedTemplateShortInfo.name)
                .then(function () {
                var parent = _this.deleteSwitchoverTemplateTreeNode(_this.selectedTemplateShortInfo.id);
                _this.selectedTemplate = null;
                _this.selectedTemplateShortInfo = null;
                _this.templatesTree.element.jstree().deselect_all();
                if (parent && parent.children && parent.children.length > 0) {
                    var node = _.find(parent.children, function (child) {
                        var childNode = _this.templatesTree.element.jstree().get_node(child);
                        if (childNode.data) {
                            return childNode;
                        }
                    });
                    if (node) {
                        _this.templatesTree.element.jstree().select_node(node);
                        return;
                    }
                }
                var rootNode = _this.templatesTree.element.jstree().get_node(_this.rootTemplatesTreeNodeId);
                if (rootNode && rootNode.children_d && _.isArray(rootNode.children_d)) {
                    var templateId = _.find(rootNode.children_d, function (child) {
                        return _.isString(child) && child.startsWith(_this.templateTreeNodeIdPrefix);
                    });
                    _this.templatesTree.element.jstree().select_node(_this.templateTreeNodeIdPrefix + templateId);
                }
            })
                .catch(function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), data);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.canEdit = function () {
        return (this.selectedTemplateShortInfo &&
            !this.selectedTemplateShortInfo.isTypical &&
            this.authentication.hasPermission(this.$rootScope.permissions.SwitchoverFormTemplateAdmin));
    };
    SwitchoverFormTemplateCtrl.prototype.canCreate = function () {
        return this.authentication.hasPermission(this.$rootScope.permissions.SwitchoverFormEdit);
    };
    SwitchoverFormTemplateCtrl.prototype.enableSortable = function () {
        angular.element('tbody[sms-sortable]').sortable('enable');
    };
    SwitchoverFormTemplateCtrl.prototype.disableSortable = function () {
        angular.element('tbody[sms-sortable]').sortable('disable');
    };
    SwitchoverFormTemplateCtrl.prototype.reorder = function (actions) {
        for (var i = 0; i < actions.length; i++) {
            actions[i].orderNumber = i + 1;
        }
        this.selectedTemplate.updateStepUiOrderNumber();
    };
    SwitchoverFormTemplateCtrl.prototype.isTypical = function () {
        return this.selectedTemplate && this.selectedTemplate.isTypical;
    };
    SwitchoverFormTemplateCtrl.prototype.save = function () {
        var _this = this;
        var deferred = this.$q.defer();
        if (angular.isUndefined(this.selectedTemplate)) {
            deferred.reject();
            return;
        }
        if (this.selectedTemplate.name === '') {
            this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsNameDontMustBeEmptyMsg'));
            deferred.reject();
            return;
        }
        if (this.selectedTemplate.chapterName === '') {
            this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsChapterDontMustBeEmptyMsg'));
            deferred.reject();
            return;
        }
        this.switchoverFormTemplateProviderService
            .isExistsExcept(this.selectedTemplate.name, this.selectedTemplate.id)
            .then(function (isTemplateExists) {
            if (isTemplateExists) {
                _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsTemplateAlreadyExistsMsg'), _this.selectedTemplate.name));
            }
            else {
                _this.switchoverFormTemplateProviderService
                    .save(_this.selectedTemplate)
                    .then(function (template) {
                    if (_this.originalTemplate.chapterName !== _this.selectedTemplate.chapterName) {
                        _this.deleteSwitchoverTemplateTreeNode(_this.originalTemplate.id);
                        _this.createNewJsTreeNodesFromTemplateInfo(_this.selectedTemplate);
                        _this.scrollToTemplate = true;
                        _this.templatesTree.element.jstree().deselect_all();
                        _this.templatesTree.element
                            .jstree()
                            .select_node(_this.templateTreeNodeIdPrefix + _this.selectedTemplate.id);
                    }
                    _this.selectedTemplate = new SwitchoverFormTemplate(template);
                    _this.originalTemplate = new SwitchoverFormTemplate(template);
                    _this.selectedTemplateShortInfo.name = template.name;
                    _this.selectedTemplateShortInfo.isTypical = template.isTypical;
                    _this.selectedTemplateShortInfo.chapterName = template.chapterName;
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessSaveTemplateMsg'));
                    deferred.resolve();
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsFailedSaveTemplateMsg'), data);
                    deferred.reject();
                });
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
            deferred.reject();
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateCtrl.prototype.importTemplates = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/ImportTemplateModal/SwitchoverFormTemplateImportModal.html',
            controller: 'switchoverFormTemplateImportModalCtrl',
            backdrop: 'static',
            resolve: {
                chapters: function () { return _this.chapters; },
            },
        })
            .result.then(function (uploadData) {
            _this.upload
                .upload(uploadData)
                .success(function (importedTemplates) {
                _.forEach(importedTemplates, function (template) {
                    var node = _this.templatesTree.element
                        .jstree()
                        .get_node(_this.templateTreeNodeIdPrefix + template.id);
                    if (node && node.data) {
                        if (node.data.chapterName !== template.chapterName) {
                            _this.deleteSwitchoverTemplateTreeNode(node.data.id);
                            _this.createNewJsTreeNodesFromTemplateInfo(template);
                            return;
                        }
                        if (node.data.isTypical !== template.isTypical) {
                            _this.templatesTree.element
                                .jstree()
                                .set_icon(_this.templateTreeNodeIdPrefix + template.id, template.isTypical ? 'fa fa-file-archive-o' : 'fa fa-file-o');
                        }
                        if (node.data.name !== template.name) {
                            _this.templatesTree.element
                                .jstree()
                                .set_text(_this.templateTreeNodeIdPrefix + template.id, template.name);
                        }
                    }
                    else {
                        _this.createNewJsTreeNodesFromTemplateInfo(template);
                    }
                    if (!_.contains(_this.chapters, template.chapterName)) {
                        _this.chapters.push(template.chapterName);
                    }
                });
                if (!_this.selectedTemplateShortInfo && importedTemplates.length > 0) {
                    _this.templatesTree.element
                        .jstree()
                        .select_node(_this.templateTreeNodeIdPrefix + importedTemplates[0].id);
                }
                else if (_this.selectedTemplateShortInfo) {
                    var updatedTemplate = _.find(importedTemplates, function (template) { return template.id === _this.selectedTemplateShortInfo.id; });
                    if (updatedTemplate) {
                        if (updatedTemplate.chapterName === _this.selectedTemplateShortInfo.chapterName) {
                            _this.selectTemplate(updatedTemplate);
                        }
                        else {
                            _this.templatesTree.element.jstree().deselect_all();
                            _this.templatesTree.element
                                .jstree()
                                .select_node(_this.templateTreeNodeIdPrefix + updatedTemplate.id);
                            _this.selectTemplate(updatedTemplate);
                        }
                    }
                }
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessTemplatesImportMsg'));
            })
                .error(function (errorInfo) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorTemplatesImportMsg'), errorInfo);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.exportTemplates = function () {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .getAllSwitchoverFormTemplatesShortInfoWithIsTypical()
            .then(function (templates) {
            _this.modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Template/ExportTemplateModal/SwitchoverFormTemplateExportModal.html',
                controller: 'switchoverFormTemplateExportModalCtrl',
                backdrop: 'static',
                resolve: {
                    templates: function () {
                        return _.map(templates, function (t) {
                            return {
                                name: t.name,
                                id: t.id,
                            };
                        });
                    },
                },
            })
                .result.then(function (result) {
                var url;
                switch (result.format) {
                    case 6:
                        url = '/SwitchoverFormTemplateExport/ExportTemplatesToDocx';
                        break;
                    case 7:
                        url = '/SwitchoverFormTemplateExport/ExportTemplatesToJson';
                        break;
                    case 1:
                        url = '/SwitchoverFormTemplateExport/ExportTemplatesToPdf';
                        break;
                    default:
                        _this.notificationService.errorMessage(String.Format(_this.language.getElementValue('switchoverFormsUnknownExportFormatMsg'), result.format.toString()));
                        return;
                }
                url += '?templateIds=' + result.ids.toString();
                _this.exportService.export(url);
            }, function () { });
        });
    };
    SwitchoverFormTemplateCtrl.prototype.print = function () {
        this.printService.printPdf('/SwitchoverFormTemplatePrint/GetPdf?id=' + this.selectedTemplate.id);
    };
    SwitchoverFormTemplateCtrl.prototype.exportTemplateTo = function (exportFileType) {
        var url = '/SwitchoverFormTemplateExport/ExportTo' + exportFileType + '?id=' + this.selectedTemplate.id;
        this.exportService.export(url);
    };
    SwitchoverFormTemplateCtrl.prototype.createForm = function () {
        this.switchoverFormService.create(this.selectedTemplate.id, this.selectedTemplate.name);
    };
    SwitchoverFormTemplateCtrl.prototype.sendMail = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/MailModal/MailSendModal.html',
            controller: 'mailSendModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                subject: function () { return _this.selectedTemplate.name; },
                hideFileTypes: function () { return [
                    0,
                    2,
                    3,
                    4,
                    5,
                ]; },
            },
        })
            .result.then(function (mailSendingInfo) {
            _this.switchoverFormTemplateProviderService
                .send(_this.selectedTemplate.id, mailSendingInfo)
                .then(function () {
                return _this.notificationService.showMessage(_this.language.getElementValue('mailWasSentSuccessfullyMsg'));
            })
                .catch(function (error) {
                return _this.notificationService.errorMessage(_this.language.getElementValue('mailWasntSentMsg'), error);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.editGeneralSettings = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/GeneralSettingsModal/SwitchoverFormTemplateGeneralSettingsModal.html',
            controller: 'switchoverFormTemplateGeneralSettingsModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                templateName: function () { return _this.selectedTemplate.name; },
                chapter: function () { return _this.selectedTemplate.chapterName; },
                chapters: function () { return _this.chapters; },
                description: function () { return _this.selectedTemplate.description; },
                isReadOnly: function () { return _this.selectedTemplate.isTypical; },
            },
        })
            .result.then(function (settings) {
            _this.switchoverFormTemplateProviderService
                .updateGeneralSettings(_this.selectedTemplate.id, settings.name, settings.chapter, settings.description)
                .then(function () {
                _this.selectedTemplate.description = settings.description;
                _this.originalTemplate.description = settings.description;
                if (settings.name !== _this.selectedTemplate.name) {
                    _this.templatesTree.element
                        .jstree()
                        .rename_node(_this.templateTreeNodeIdPrefix + _this.selectedTemplate.id, settings.name);
                    angular
                        .element('#' + _this.templateTreeNodeIdPrefix + _this.selectedTemplate.id + '_anchor')
                        .attr('title', settings.name);
                    _this.selectedTemplate.name = settings.name;
                    _this.originalTemplate.name = settings.name;
                }
                if (settings.chapter !== _this.selectedTemplate.chapterName) {
                    _this.selectedTemplate.chapterName = settings.chapter;
                    _this.originalTemplate.chapterName = settings.chapter;
                    _this.deleteSwitchoverTemplateTreeNode(_this.selectedTemplate.id);
                    _this.createNewJsTreeNodesFromTemplateInfo(_this.selectedTemplate);
                    _this.scrollToTemplate = true;
                    _this.templatesTree.element.jstree().deselect_all();
                    _this.templatesTree.element
                        .jstree()
                        .select_node(_this.templateTreeNodeIdPrefix + _this.selectedTemplate.id);
                    if (!_.contains(_this.chapters, settings.chapter)) {
                        _this.chapters.push(settings.chapter);
                    }
                }
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsTemplateSuccessfullyUpdatedMsg'));
            })
                .catch(function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsFailedUpdateDescriptionMsg'), error);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.editAttachments = function () {
        var _this = this;
        this.switchoverFormTemplateAttachmentProviderService
            .getAttachments(this.selectedTemplate.id)
            .then(function (attachments) {
            _this.modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Template/EditAttachmentsModal/SwitchoverFormTemplateAttachmentsModal.html',
                controller: 'switchoverFormTemplateAttachmentsModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    templateId: function () { return _this.selectedTemplate.id; },
                    attachments: function () { return attachments; },
                },
            });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsTemplateAttachmentsFailedToUploadMsg'), error);
        });
    };
    SwitchoverFormTemplateCtrl.prototype.setTypical = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/SetTemplateTypicalModal/SetSwitchoverFormTemplateTypicalModal.html',
            controller: 'setSwitchoverFormTemplateTypicalModalCtrl',
        })
            .result.then(function () {
            _this.switchoverFormTemplateProviderService
                .setTypical(_this.selectedTemplate.id, _this.selectedTemplate.name)
                .then(function () {
                _this.selectedTemplate.isTypical = true;
                _this.originalTemplate.isTypical = true;
                _this.selectedTemplateShortInfo.isTypical = true;
                _this.editorConfiguration.config.readOnly = true;
                _this.templatesTree.element
                    .jstree()
                    .set_icon(_this.templateTreeNodeIdPrefix + _this.selectedTemplate.id, 'fa fa-file-archive-o');
            })
                .catch(function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsSetTypicalTemplateErrorMsg'), error);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.openTemplate = function (templateId) {
        this.location.url('/switchover-form-templates/' + templateId);
    };
    SwitchoverFormTemplateCtrl.prototype.openParentTemplate = function () {
        var _this = this;
        var templates = this.getTemplatesShortInfo();
        var parentTemplate = _.find(templates, function (t) { return t.id === _this.selectedTemplate.parentTemplateId; });
        if (parentTemplate) {
            this.scrollToTemplate = true;
            this.templatesTree.element.jstree().deselect_all();
            this.templatesTree.element
                .jstree()
                .select_node(this.templateTreeNodeIdPrefix + this.selectedTemplate.parentTemplateId, false, false, {
                scroll: true,
            });
        }
        else {
            this.notificationService.errorMessage(this.language.getElementValue('switchoverFormsCouldNotFindParentTemplate'));
        }
    };
    SwitchoverFormTemplateCtrl.prototype.hasParentTemplate = function () {
        return this.selectedTemplate && !_.isUndefined(this.selectedTemplate.parentTemplateId);
    };
    SwitchoverFormTemplateCtrl.prototype.editOperation = function (operation) {
        var _this = this;
        if (this.isTypical()) {
            return;
        }
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Operations/EditOperationModal/SwitchoverFormEditOperationModal.html',
            controller: 'SwitchoverFormTemplateEditOperationModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                operation: function () {
                    return operation.switchoverFormCommonOperation;
                },
                operations: function () {
                    return undefined;
                },
                isEditable: function () {
                    return !operation.switchoverFormCommonOperation.isTypical;
                },
                isTypical: function () {
                    return false;
                },
            },
        });
        modalInstance.result.then(function (selectedOperation) {
            operation.switchoverFormCommonOperation = selectedOperation;
            operation.switchoverFormCommonOperationId = selectedOperation.id;
            operation.isOrderNumberHidden =
                operation.isOrderNumberHidden || selectedOperation.type === 2;
            _this.selectedTemplate.updateStepUiOrderNumber();
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.listItemClick = function (onStepSelect) {
        this.selectedStep = onStepSelect;
    };
    SwitchoverFormTemplateCtrl.prototype.addOperation = function (index) {
        var orderNumber = this.selectedTemplate.operations.length === 0 ? 1 : this.selectedTemplate.operations[index].orderNumber + 1;
        var operation = {
            id: 0,
            switchoverFormTemplateId: this.selectedTemplate.id,
            orderNumber: orderNumber,
            isOrderNumberHidden: false,
            switchoverFormCommonOperation: {
                id: 0,
                description: this.getDescription(this.language.getElementValue('switchoverFormOperationHdr'), orderNumber),
                commands: [],
                type: 0,
            },
        };
        this.calculateOperationPosition(index, operation);
        this.editOperation(operation);
    };
    SwitchoverFormTemplateCtrl.prototype.selectOperation = function (index) {
        var _this = this;
        this.switchoverFormTypicalOperationsProviderService
            .getAllTypicalOperations()
            .then(function (operations) {
            _this.typicalOperations = operations;
            var modalInstance = _this.modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Template/SelectTypicalOperationModal/SelectTypicalOperationModal.html',
                controller: 'switchoverFormTemplateTypicalOperationSelectModalCtrl',
                windowClass: 'app-modal-window typical-list-modal',
                backdrop: 'static',
                resolve: {
                    operations: function () { return _this.typicalOperations; },
                },
            });
            modalInstance.result.then(function (selectedOperation) {
                var orderNumber = _this.selectedTemplate.operations.length === 0
                    ? 1
                    : _this.selectedTemplate.operations[index].orderNumber + 1;
                var operation = {
                    id: 0,
                    switchoverFormTemplateId: _this.selectedTemplate.id,
                    orderNumber: orderNumber,
                    isOrderNumberHidden: selectedOperation.type === 2,
                    switchoverFormCommonOperation: {
                        id: selectedOperation.id,
                        description: selectedOperation.description,
                        type: selectedOperation.type,
                        commands: selectedOperation.commands,
                        isTypical: true,
                    },
                };
                _this.calculateOperationPosition(index, operation);
            }, function () { });
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), data);
        });
    };
    SwitchoverFormTemplateCtrl.prototype.copyOperation = function (index) {
        var copiedOperation = angular.copy(this.selectedTemplate.operations[index]);
        var orderNumber = this.selectedTemplate.operations.length === 0 ? 1 : this.selectedTemplate.operations[index].orderNumber + 1;
        copiedOperation.id = 0;
        copiedOperation.orderNumber = orderNumber;
        if (!copiedOperation.switchoverFormCommonOperation.isTypical) {
            copiedOperation.switchoverFormCommonOperationId = 0;
            copiedOperation.switchoverFormCommonOperation.id = 0;
            _.forEach(copiedOperation.switchoverFormCommonOperation.commands, function (command) {
                command.id = 0;
                command.switchoverFormCommonOperationId = 0;
            });
        }
        this.calculateOperationPosition(index, copiedOperation);
    };
    SwitchoverFormTemplateCtrl.prototype.deleteOperation = function (index) {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('switchoverFormsDeleteTypicalOperationHdr'); },
                body: function () {
                    return String.Format(_this.language.getElementValue('switchoverFormsDeleteTypicalOperationQuestionHdr'), _this.selectedTemplate.name);
                },
            },
        })
            .result.then(function () {
            try {
                _this.selectedTemplate.operations.splice(index, 1);
                for (var i = index; i < _this.selectedTemplate.operations.length; i++) {
                    _this.selectedTemplate.operations[i].orderNumber--;
                }
                _this.selectedTemplate.updateStepUiOrderNumber();
            }
            catch (_a) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorDeleteOperationMsg'));
            }
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.changeOperationOrderNumberVisibility = function (operation) {
        operation.isOrderNumberHidden = !operation.isOrderNumberHidden;
        this.selectedTemplate.updateStepUiOrderNumber();
    };
    SwitchoverFormTemplateCtrl.prototype.isAutomaticOperation = function (operation) {
        return (operation.switchoverFormCommonOperation &&
            operation.switchoverFormCommonOperation.type === 1);
    };
    SwitchoverFormTemplateCtrl.prototype.isTextOperation = function (operation) {
        return operation.switchoverFormCommonOperation.type === 2;
    };
    SwitchoverFormTemplateCtrl.prototype.getStepEditorConfigurationOperation = function (operation) {
        return this.selectedTemplate.isTypical || operation.switchoverFormCommonOperation.isTypical
            ? this.stepReadOnlyEditorConfiguration.config
            : this.stepEditorConfiguration.config;
    };
    SwitchoverFormTemplateCtrl.prototype.isPreviousTextOperation = function (index) {
        if (index === 0) {
            return false;
        }
        return (this.selectedTemplate.operations[index - 1].switchoverFormCommonOperation.type ===
            2);
    };
    SwitchoverFormTemplateCtrl.prototype.editCondition = function (condition) {
        var _this = this;
        if (this.isTypical()) {
            return;
        }
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/EditConditionModal/SwitchoverFormEditConditionModal.html',
            controller: 'SwitchoverFormTemplateEditConditionModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                condition: function () {
                    return condition.switchoverFormCommonCondition;
                },
                conditions: function () {
                    return undefined;
                },
                isEditable: function () {
                    return !condition.switchoverFormCommonCondition.isTypical;
                },
                isTypical: function () {
                    return false;
                },
            },
        });
        modalInstance.result.then(function (selectedCondition) {
            condition.switchoverFormCommonCondition = selectedCondition;
            condition.switchoverFormCommonConditionId = selectedCondition.id;
            condition.isOrderNumberHidden =
                condition.isOrderNumberHidden || selectedCondition.type === 2;
            _this.selectedTemplate.updateStepUiOrderNumber();
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.addCondition = function (index) {
        var orderNumber = this.selectedTemplate.conditions.length === 0 ? 1 : this.selectedTemplate.conditions[index].orderNumber + 1;
        var condition = {
            id: 0,
            switchoverFormTemplateId: this.selectedTemplate.id,
            orderNumber: orderNumber,
            isOrderNumberHidden: false,
            switchoverFormCommonCondition: {
                id: 0,
                description: this.getDescription(this.language.getElementValue('switchoverFormConditionHdr'), orderNumber),
                commands: [],
                type: 0,
            },
        };
        this.calculateConditionPosition(index, condition);
        this.editCondition(condition);
    };
    SwitchoverFormTemplateCtrl.prototype.selectCondition = function (index) {
        var _this = this;
        this.switchoverFormTypicalConditionsProviderService
            .getAllTypicalConditions()
            .then(function (conditions) {
            _this.typicalConditions = conditions;
            var modalInstance = _this.modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Template/SelectTypicalConditionModal/SelectTypicalConditionModal.html',
                controller: 'switchoverFormTemplateTypicalConditionSelectModalCtrl',
                windowClass: 'app-modal-window typical-list-modal',
                backdrop: 'static',
                resolve: {
                    conditions: function () { return _this.typicalConditions; },
                },
            });
            modalInstance.result.then(function (selectedCondition) {
                try {
                    var orderNumber = _this.selectedTemplate.conditions.length === 0
                        ? 1
                        : _this.selectedTemplate.conditions[index].orderNumber + 1;
                    var condition = {
                        id: 0,
                        switchoverFormTemplateId: _this.selectedTemplate.id,
                        orderNumber: orderNumber,
                        isOrderNumberHidden: selectedCondition.type === 2,
                        switchoverFormCommonCondition: {
                            id: selectedCondition.id,
                            description: selectedCondition.description,
                            type: selectedCondition.type,
                            commands: selectedCondition.commands,
                            isTypical: true,
                        },
                    };
                    _this.calculateConditionPosition(index, condition);
                }
                catch (_a) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'));
                }
            }, function () { });
        });
    };
    SwitchoverFormTemplateCtrl.prototype.copyCondition = function (index) {
        var copiedCondition = angular.copy(this.selectedTemplate.conditions[index]);
        var orderNumber = this.selectedTemplate.conditions.length === 0 ? 1 : this.selectedTemplate.conditions[index].orderNumber + 1;
        copiedCondition.id = 0;
        copiedCondition.orderNumber = orderNumber;
        if (!copiedCondition.switchoverFormCommonCondition.isTypical) {
            copiedCondition.switchoverFormCommonConditionId = 0;
            copiedCondition.switchoverFormCommonCondition.id = 0;
            _.forEach(copiedCondition.switchoverFormCommonCondition.commands, function (command) {
                command.id = 0;
                command.switchoverFormCommonConditionId = 0;
            });
        }
        this.calculateConditionPosition(index, copiedCondition);
    };
    SwitchoverFormTemplateCtrl.prototype.deleteCondition = function (index) {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('switchoverFormsDeleteTypicalConditionHdr'); },
                body: function () {
                    return String.Format(_this.language.getElementValue('switchoverFormsDeleteTypicalConditionQuestionHdr'), _this.selectedTemplate.name);
                },
            },
        })
            .result.then(function () {
            try {
                _this.selectedTemplate.conditions.splice(index, 1);
                for (var i = index; i < _this.selectedTemplate.conditions.length; i++) {
                    _this.selectedTemplate.conditions[i].orderNumber--;
                }
                _this.selectedTemplate.updateStepUiOrderNumber();
            }
            catch (_a) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorDeleteConditionMsg'));
            }
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.changeConditionOrderNumberVisibility = function (condition) {
        condition.isOrderNumberHidden = !condition.isOrderNumberHidden;
        this.selectedTemplate.updateStepUiOrderNumber();
    };
    SwitchoverFormTemplateCtrl.prototype.isAutomaticCondition = function (condition) {
        return (condition.switchoverFormCommonCondition &&
            condition.switchoverFormCommonCondition.type === 1);
    };
    SwitchoverFormTemplateCtrl.prototype.isTextCondition = function (condition) {
        return condition.switchoverFormCommonCondition.type === 2;
    };
    SwitchoverFormTemplateCtrl.prototype.isPreviousTextCondition = function (index) {
        if (index === 0) {
            return false;
        }
        return (this.selectedTemplate.conditions[index - 1].switchoverFormCommonCondition.type ===
            2);
    };
    SwitchoverFormTemplateCtrl.prototype.getStepEditorConfigurationCondition = function (condition) {
        return this.selectedTemplate.isTypical || condition.switchoverFormCommonCondition.isTypical
            ? this.stepReadOnlyEditorConfiguration.config
            : this.stepEditorConfiguration.config;
    };
    SwitchoverFormTemplateCtrl.prototype.editAlarms = function () {
        var _this = this;
        if (!this.alarms) {
            this.switchoverFormAlarmsProviderService
                .getAllAlarms()
                .then(function (alarms) {
                _this.alarms = alarms;
                _this.openAlarmsModal();
            })
                .catch(function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorGetListOfAlarmsMsg'), data);
            });
        }
        else {
            this.openAlarmsModal();
        }
    };
    SwitchoverFormTemplateCtrl.prototype.getToolbarId = function () {
        return this.ckeditorToolbarId;
    };
    SwitchoverFormTemplateCtrl.prototype.loadTemplate = function (templateShortInfo) {
        var _this = this;
        if (!templateShortInfo) {
            this.selectedTemplateShortInfo = null;
            return;
        }
        this.selectedTemplateShortInfo = templateShortInfo;
        this.stepEditorConfiguration.config.readOnly = templateShortInfo.isTypical;
        this.editorConfiguration.config.readOnly = templateShortInfo.isTypical;
        this.switchoverFormTemplateProviderService
            .getSwitchoverFormTemplate(templateShortInfo.id)
            .then(function (template) {
            _this.selectedTemplate = new SwitchoverFormTemplate(template);
            _this.originalTemplate = new SwitchoverFormTemplate(template);
        })
            .catch(function (data) {
            _this.selectedTemplateShortInfo = null;
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsLoadTemplateErrorMsg'), data);
        });
    };
    SwitchoverFormTemplateCtrl.prototype.createCopyOfSelectedTemplate = function () {
        var _this = this;
        var copiedTemplateName = this.getCopiedTemplateName(String.Format(this.language.getElementValue('copyHdr'), this.selectedTemplateShortInfo.name), this.selectedTemplateShortInfo.isTypical);
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/CreateTemplateModal/CreateSwitchoverFormTemplateModal.html',
            controller: 'createSwitchoverFormTemplateModalCtrl',
            backdrop: 'static',
            resolve: {
                templateName: function () { return copiedTemplateName; },
                chapter: function () { return _this.selectedTemplateShortInfo.chapterName; },
                chapters: function () { return _this.chapters; },
                isCopy: function () { return true; },
            },
        });
        modalInstance.result.then(function (createTemplateInfo) {
            _this.switchoverFormTemplateProviderService
                .copy(createTemplateInfo.templateName, _this.selectedTemplateShortInfo.id, 1)
                .then(function (templateId) {
                _this.switchoverFormTemplateProviderService
                    .getSwitchoverFormTemplate(templateId)
                    .then(function (template) {
                    var newTemplate = template;
                    var templateTreeNode = _this.createNewJsTreeNodesFromTemplateInfo(newTemplate);
                    _this.templatesTree.element.jstree().deselect_all(true);
                    _this.templatesTree.element.jstree().select_node(templateTreeNode);
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCopyTemplateMsg'), data);
                });
            })
                .catch(function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCopyTemplateMsg'), data);
            });
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.openAlarmsModal = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/EditTemplateAlarmsModal/EditTemplateAlarmsModal.html',
            controller: 'editTemplateAlarmsModalCtrl',
            windowClass: 'app-modal-window edit-template-alarms-modal',
            backdrop: 'static',
            resolve: {
                templateId: function () { return _this.selectedTemplate.id; },
                templateAlarms: function () { return _this.selectedTemplate.alarms; },
                alarms: function () { return _this.alarms; },
            },
        })
            .result.then(function (alarms) {
            _this.selectedTemplate.alarms = alarms;
        }, function () { });
    };
    SwitchoverFormTemplateCtrl.prototype.getCopiedTemplateName = function (templateName, isTypical) {
        var now = new Date();
        var result = templateName + ' (' + now.format(Date.masks.fullDateTime) + ')';
        if (!isTypical) {
            return result;
        }
        var nameBuilderText = result.trim().toLowerCase();
        var typicalText = this.language.getElementValue('switchoverFormsTypeTypicalHdr').toLowerCase();
        if (nameBuilderText.lastIndexOf(typicalText + ' ', 0) === 0) {
            result = result.slice(typicalText.length + 1);
            result = result.charAt(0).toUpperCase() + result.slice(1);
        }
        return result;
    };
    SwitchoverFormTemplateCtrl.prototype.calculateCkeditorToolbarPosition = function () {
        var toolbarElement = angular.element('#' + this.ckeditorToolbarId);
        var topOffset = 0;
        var leftOffset = 0;
        var editorAreaOffset = this.editableEditor.container.getClientRect();
        if (editorAreaOffset && editorAreaOffset.top && editorAreaOffset.left) {
            topOffset = editorAreaOffset.top;
            leftOffset = editorAreaOffset.left;
        }
        var templateBodyOffsetTop = angular.element('#' + this.templateBodyElementId).offset().top;
        var toolBarHeight = toolbarElement.height();
        if (topOffset <= templateBodyOffsetTop + toolBarHeight) {
            var coordinates = {
                top: templateBodyOffsetTop,
                left: leftOffset,
            };
            toolbarElement.css({ position: 'fixed' });
            toolbarElement.offset(coordinates);
        }
        else {
            toolbarElement.css({ position: 'absolute' });
            var topOffsetOfPageScroll = 0;
            var newTopOffset = topOffset + topOffsetOfPageScroll - toolBarHeight;
            var coordinates = {
                top: newTopOffset,
                left: leftOffset,
            };
            toolbarElement.offset(coordinates);
        }
    };
    SwitchoverFormTemplateCtrl.prototype.getCustomToolbarJqueryElement = function () {
        return angular.element('#' + this.ckeditorToolbarId);
    };
    SwitchoverFormTemplateCtrl.prototype.calculateTemplatesListBlockHeight = function () {
        var footerElements = angular.element('.switchover-form-template-expand-btn');
        var templateListElements = angular.element('.switchover-from-templates-groups');
        templateListElements.each(function (indexList, elementList) {
            footerElements.each(function (indexF, elementF) {
                if (indexList === indexF) {
                    angular
                        .element(elementList)
                        .outerHeight(angular.element(elementF).offset().top - angular.element(elementList).offset().top);
                }
            });
        });
    };
    SwitchoverFormTemplateCtrl.prototype.calculateTemplateBodyBlockHeight = function () {
        var windowHeight = angular.element(window).height();
        var templateBodyElements = angular.element('.switchover-form-template-body');
        templateBodyElements.each(function (indexList, templateBodyElement) {
            var elementTop = angular.element(templateBodyElement).offset().top;
            var newElementHeight = windowHeight - elementTop - 10;
            angular.element(templateBodyElement).outerHeight(newElementHeight);
        });
    };
    SwitchoverFormTemplateCtrl.prototype.calculateBlocksHeight = function () {
        this.calculateTemplateBodyBlockHeight();
        this.calculateTemplatesListBlockHeight();
    };
    SwitchoverFormTemplateCtrl.prototype.calculateConditionPosition = function (index, condition) {
        for (var i = index + 1; i < this.selectedTemplate.conditions.length; i++) {
            this.selectedTemplate.conditions[i].orderNumber++;
        }
        this.selectedTemplate.conditions.splice(index + 1, 0, condition);
        this.selectedTemplate.updateStepUiOrderNumber();
    };
    SwitchoverFormTemplateCtrl.prototype.calculateOperationPosition = function (index, operation) {
        for (var i = index + 1; i < this.selectedTemplate.operations.length; i++) {
            this.selectedTemplate.operations[i].orderNumber++;
        }
        this.selectedTemplate.operations.splice(index + 1, 0, operation);
        this.selectedTemplate.updateStepUiOrderNumber();
    };
    SwitchoverFormTemplateCtrl.prototype.getTemplatesShortInfo = function () {
        var options = {
            no_id: false,
            no_children: false,
            no_data: false,
            no_li_attr: true,
            no_a_attr: true,
            flat: true,
        };
        var templates = _.filter(_.map(this.templatesTree.element
            .jstree()
            .get_json(this.rootTemplatesTreeNodeId, options), function (node) { return node.data; }), function (template) {
            return !_.isEmpty(template);
        });
        return templates;
    };
    SwitchoverFormTemplateCtrl.prototype.addNewSwitchoverTemplateTreeNodesFromTemplateInfo = function (template, isNodeExists, templateTreeNodes) {
        var chapterLevels = template.chapterName.split(this.chaptersSeparator);
        var node = {
            id: this.templateTreeNodeIdPrefix + template.id.toString(),
            parent: template.chapterName + '_' + (chapterLevels.length - 1),
            text: template.name,
            a_attr: { title: template.name },
            icon: template.isTypical ? 'fa fa-file-archive-o' : 'fa fa-file-o',
            isTemplate: true,
            data: template,
        };
        templateTreeNodes.push(node);
        for (var level = chapterLevels.length - 1; level >= 0; level--) {
            var parentId = this.rootTemplatesTreeNodeId;
            if (level > 0) {
                parentId = chapterLevels.slice(0, level).join(this.chaptersSeparator) + '_' + (level - 1);
            }
            var groupNode = {
                id: chapterLevels.slice(0, level + 1).join(this.chaptersSeparator) + '_' + level,
                parent: parentId,
                text: chapterLevels[level],
                a_attr: { title: chapterLevels[level] },
                icon: 'fa fa-folder',
                isTemplate: false,
                data: null,
            };
            if (!isNodeExists(groupNode)) {
                templateTreeNodes.push(groupNode);
            }
        }
    };
    SwitchoverFormTemplateCtrl.prototype.createNewJsTreeNodesFromTemplateInfo = function (template) {
        var _this = this;
        var isNodeExists = function (currentNode) {
            return !_.isEmpty(_this.templatesTree.element.jstree().get_node(currentNode.id));
        };
        var newTreeNodes = [];
        this.addNewSwitchoverTemplateTreeNodesFromTemplateInfo(template, isNodeExists, newTreeNodes);
        for (var i = newTreeNodes.length - 1; i >= 0; i--) {
            this.templatesTree.element.jstree().create_node(newTreeNodes[i].parent, newTreeNodes[i]);
        }
        return newTreeNodes[0];
    };
    SwitchoverFormTemplateCtrl.prototype.deleteSwitchoverTemplateTreeNode = function (templateId) {
        var currentNode = this.templatesTree.element.jstree().get_node(this.templateTreeNodeIdPrefix + templateId);
        var parent = null;
        if (currentNode) {
            this.templatesTree.element.jstree().delete_node(currentNode.id);
            var parentId = currentNode.parent;
            while (parentId) {
                var node = this.templatesTree.element.jstree().get_node(parentId);
                parent = node;
                if (node && (!node.children || node.children.length === 0)) {
                    parentId = node.parent;
                    this.templatesTree.element.jstree().delete_node(node.id);
                    continue;
                }
                break;
            }
        }
        return parent;
    };
    SwitchoverFormTemplateCtrl.prototype.scrollToSelectedTemplate = function () {
        var templateListElement = angular.element('#' + this.templatesListElementId);
        var selectedTemplateElement = angular.element('#' + this.templateTreeNodeIdPrefix + this.selectedTemplateShortInfo.id + '_anchor');
        if (templateListElement &&
            selectedTemplateElement &&
            templateListElement.length &&
            selectedTemplateElement.length) {
            templateListElement.scrollTop(templateListElement.scrollTop() +
                selectedTemplateElement.offset().top -
                templateListElement.offset().top);
        }
    };
    SwitchoverFormTemplateCtrl.prototype.getDescription = function (descriptionName, orderNumber) {
        var getColumnStyle = function (width) { return "width: ".concat(width, "px; border: none; padding: 0; text-align: left"); };
        var location = this.language.getElementValue('switchoverFormsCommandCpuHdr');
        var name = descriptionName + ' ' + orderNumber.toString();
        return ('<table style="width: 100%; border: none">\n' +
            '   <tbody>\n' +
            '       <tr>\n' +
            "           <td style=\"".concat(getColumnStyle(200), "\">").concat(location, "</td>\n") +
            "           <td style=\"".concat(getColumnStyle(700), "\">").concat(name, "</td>\n") +
            '       </tr>\n' +
            '   </tbody>\n' +
            '</table>');
    };
    SwitchoverFormTemplateCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$routeParams',
        '$location',
        '$modal',
        '$q',
        '$upload',
        'authentication',
        'language',
        'switchoverFormService',
        'switchoverFormTemplateProvider',
        'switchoverFormTemplateAttachmentProvider',
        'switchoverFormTypicalOperationsProvider',
        'switchoverFormTypicalConditionsProvider',
        'switchoverFormAlarmsProvider',
        'switchoverFormsCkeditorConfigurationProvider',
        'notificationService',
        'mailProvider',
        'browserInfoProvider',
        'exportService',
        'printService',
    ];
    return SwitchoverFormTemplateCtrl;
}());
angular.module('kamhpp').controller('SwitchoverFormTemplateCtrl', SwitchoverFormTemplateCtrl);
