var TagsTreeConfigurationProvider = (function () {
    function TagsTreeConfigurationProvider(languageService) {
        this.languageService = languageService;
    }
    TagsTreeConfigurationProvider.prototype.getConfiguration = function (tagTreeType, data, isMultiselectEnabled) {
        return {
            plugins: this.getPlugins(tagTreeType),
            core: {
                multiple: isMultiselectEnabled,
                data: data
            },
            grid: this.getGridSettings(tagTreeType),
            state: {
                key: this.getTreeName(tagTreeType),
            }
        };
    };
    TagsTreeConfigurationProvider.prototype.getTreeName = function (tagTreeType) {
        switch (tagTreeType) {
            case TagTreeType.WinccOaPara:
                return 'ParaTagsTree';
            case TagTreeType.WinccOaCns:
                return 'CnsTagsTree';
            case TagTreeType.Opc:
                return 'OpcTagsTree';
        }
    };
    TagsTreeConfigurationProvider.prototype.getPlugins = function (tagTreeType) {
        var plugins = ['types', 'state', 'sort'];
        if (tagTreeType === TagTreeType.WinccOaCns) {
            plugins.push('grid');
        }
        return plugins;
    };
    TagsTreeConfigurationProvider.prototype.getGridSettings = function (tagTreeType) {
        switch (tagTreeType) {
            case TagTreeType.WinccOaPara:
            case TagTreeType.Opc:
                return {};
            case TagTreeType.WinccOaCns:
                return {
                    columns: [
                        {
                            header: this.languageService.getElementValue('denominationHdr'),
                            width: '70%'
                        },
                        {
                            header: this.languageService.getElementValue('locationHdr'),
                            value: function (node) {
                                return (node.original.location);
                            },
                            width: '30%'
                        }
                    ],
                    fixedHeader: true,
                    height: '100%'
                };
        }
    };
    TagsTreeConfigurationProvider.$inject = ['language'];
    return TagsTreeConfigurationProvider;
}());
angular
    .module('kamhpp')
    .service('tagsTreeConfigurationProvider', TagsTreeConfigurationProvider);
