var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var UiSelectClassInfo = (function (_super) {
    __extends(UiSelectClassInfo, _super);
    function UiSelectClassInfo(id, name, hasParent) {
        var _this = _super.call(this, id, name) || this;
        _this.hasParent = hasParent;
        return _this;
    }
    return UiSelectClassInfo;
}(UiSelectItem));
var DropdownSettingsCtrl = (function () {
    function DropdownSettingsCtrl(parentScope, notificationService, language, http, clientSettings, authentication) {
        this.language = language;
        this.http = http;
        this.clientSettings = clientSettings;
        this.authentication = authentication;
        this.watchFunctions = [];
        this.dictionaries = [];
        this.classes = [];
        this.parentInstances = [];
        this.parentScope = parentScope;
        this.variations = [];
        this.notificationService = notificationService;
    }
    DropdownSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.parentScope.param.Editable = true;
        if (this.authentication.hasPermission(this.parentScope.$parent.permissions.CimView)) {
            this.http.get(this.clientSettings.getServerInstance() + '/CimModel/GetDictionaryProfiles').then(function (response) {
                _this.dictionary = response.data;
                self.isCorrect = true;
                try {
                    self.variations = _.map(JSON.parse(_this.parentScope.param.Dropdown.variations), function (i) {
                        return new UiSelectItem(i, i);
                    });
                }
                catch (e) {
                    _this.variations = [];
                }
                var filteredParameters = _.filter(self.parentScope.reportTemplate.Parameters, function (i) {
                    return i.Ident !== _this.parentScope.param.Ident && i.ParameterType === 'string';
                });
                var arrayParameters = _.filter(self.parentScope.reportTemplate.Parameters, function (i) {
                    return (i.ParameterType === 'Dictionary<string, string>'
                        || i.ParameterType === 'string[]'
                        || i.ParameterType === 'int[]'
                        || i.ParameterType === 'double[]');
                });
                _this.dictionaryReportParameters = getVariantsContainer(_this.parentScope, _.map(arrayParameters, function (parameter) {
                    return new UiSelectItem(parameter.Ident, parameter.Source);
                }), function (t) {
                    return t.ident === _this.parentScope.param.Dropdown.initialParameter;
                }, function (after, before) {
                    if (after === before || _.isUndefined(after))
                        return;
                    _this.parentScope.param.Dropdown.anotherParameterSourceIdent = after.ident;
                    _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
                });
                _this.dictionaries = _.map(self.dictionary, function (d) {
                    return new UiSelectItem(d.Id, d.Name);
                });
                _this.updateClasses();
                _this.updateParentInstances();
                _this.paramSources = getVariantsContainer(_this.parentScope, [
                    new UiSelectItem(0, _this.language.getElementValue('reportParameterDropdownManualTypeHdr')),
                    new UiSelectItem(2, _this.language.getElementValue('reportParameterDropdownDictionaryTypeHdr')),
                    new UiSelectItem(1, _this.language.getElementValue('reportParameterDropdownAnotherParameterTypeHdr'))
                ], function (t) {
                    return t.ident === self.parentScope.param.Dropdown.source;
                }, function (after, before) {
                    if (after === before || after == undefined) {
                        return;
                    }
                    self.parentScope.param.Dropdown = new ReportParameterDropdown();
                    self.parentScope.param.Dropdown.source = after.ident;
                });
                _this.defaultValueReportParameterIdents = getVariantsContainer(_this.parentScope, _.map(filteredParameters, function (parameter) {
                    return new UiSelectItem(parameter.Ident, parameter.Source);
                }), function (t) {
                    return t.ident === _this.parentScope.param.Dropdown.initialParameter;
                }, function (after, before) {
                    if (after === before || _.isUndefined(after))
                        return;
                    _this.parentScope.param.Dropdown.initialParameter = after.ident;
                    _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
                });
                _this.watchFunctions.push(_this.parentScope.$watch(function () {
                    return _this.variations;
                }, function () {
                    if (_this.checkDuplication()) {
                        if (_this.isCorrect) {
                            _this.notificationService.errorMessage(_this.language.getElementValue('reportParameterDropdownThereAreDuplicatesMsg'));
                            _this.isCorrect = false;
                        }
                    }
                    else
                        _this.isCorrect = true;
                    _this.parentScope.param.Dropdown.variations = JSON.stringify(_.map(_this.variations, function (i) {
                        return i.name;
                    }));
                    var defaultValues = _.map(_this.variations, function (item) { return new UiSelectItem(0, item.name); });
                    defaultValues.push(new UiSelectItem(1, _this.language.getElementValue('reportParameterDropdownOtherParameterHdr')));
                    _this.defaultValueVariationsContainer = getVariantsContainer(_this.parentScope, defaultValues, function (t) {
                        return t.name === _this.parentScope.param.Dropdown.defaultValue;
                    }, function (after, before) {
                        if (_.isUndefined(after) || before === after)
                            return;
                        if (after.ident === 0) {
                            _this.defaultValueReportParameterIdents.selected = undefined;
                        }
                        _this.parentScope.param.Dropdown.defaultValue = after.name;
                        _this.parentScope.param.Dropdown.defaultValueType = after.ident;
                    });
                }, true));
                _this.watchFunctions.push(_this.parentScope.$watch(function () {
                    return _this.parentScope.param.Dropdown;
                }, function (value) {
                    if (value == undefined)
                        return;
                    _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
                }, true));
                _this.parentScope.settingsCtrl.formulaCtrl.setResultType('DropDownValue');
                _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
            });
        }
    };
    DropdownSettingsCtrl.prototype.destroy = function () {
        var _a, _b, _c, _d;
        (_a = this.dictionaryReportParameters) === null || _a === void 0 ? void 0 : _a.destroy();
        (_b = this.paramSources) === null || _b === void 0 ? void 0 : _b.destroy();
        (_c = this.defaultValueVariationsContainer) === null || _c === void 0 ? void 0 : _c.destroy();
        (_d = this.defaultValueReportParameterIdents) === null || _d === void 0 ? void 0 : _d.destroy();
        _.forEach(this.watchFunctions, function (f) {
            if (!_.isUndefined(f)) {
                f();
            }
        });
    };
    DropdownSettingsCtrl.prototype.getFormula = function () {
        var _this = this;
        var variants = "";
        var defaultValue = 'null';
        switch (this.parentScope.param.Dropdown.source) {
            case 0: {
                var dictVariants_1 = '';
                _.forEach(JSON.parse(this.parentScope.param.Dropdown.variations), function (val, idx) {
                    dictVariants_1 += idx === (_this.parentScope.param.Dropdown.variations.length - 1)
                        ? '{"' + val + '","' + val + '"}\n'
                        : '{"' + val + '","' + val + '"}\n,';
                });
                variants = "new Dictionary<string, string>() { " + dictVariants_1 + " }";
                if (this.parentScope.param.Dropdown.defaultValue) {
                    defaultValue = this.parentScope.param.Dropdown.defaultValueType === 0
                        ? 'new string[]{"' + this.parentScope.param.Dropdown.defaultValue + '"}'
                        : 'new string[]{%' + this.parentScope.param.Dropdown.initialParameter + '%}';
                }
                break;
            }
            case 1: {
                var parameter = _.find(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === _this.parentScope.param.Dropdown.anotherParameterSourceIdent; });
                if (parameter) {
                    switch (parameter.ParameterType) {
                        case 'int[]':
                        case 'string[]':
                        case 'double[]':
                            variants = '%' + this.parentScope.param.Dropdown.anotherParameterSourceIdent + '%.Distinct().Select(v => new KeyValuePair<string, string>(v.ToString(), v.ToString())).ToDictionary(v => v.Key, v => v.Value)';
                            break;
                        case 'Dictionary<string, string>':
                            variants = '%' + this.parentScope.param.Dropdown.anotherParameterSourceIdent + '%';
                            break;
                    }
                }
                break;
            }
            case 2: {
                var parent_1 = this.parentScope.param.Dropdown.dictionarySettings.parentInstanceParameterIdent
                    ? '%' + this.parentScope.param.Dropdown.dictionarySettings.parentInstanceParameterIdent + '%'
                    : 'null';
                variants = 'GetChildrenClassInstances("' + this.parentScope.param.Dropdown.dictionarySettings.classUniqueCode + '", ' + parent_1 + ').ToDictionary(c => c.UniqueCode, c => c.Name)';
                if (this.parentScope.param.Dropdown.dictionarySettings.additionalVariants && _.any(this.parentScope.param.Dropdown.dictionarySettings.additionalVariants)) {
                    var dictVariants_2 = '';
                    _.forEach(this.parentScope.param.Dropdown.dictionarySettings.additionalVariants, function (val, idx) {
                        dictVariants_2 += idx === (_this.parentScope.param.Dropdown.variations.length - 1)
                            ? '{"' + val + '","' + val + '"}\n'
                            : '{"' + val + '","' + val + '"}\n,';
                    });
                    variants += '.Concat(new Dictionary<string, string>() { ' + dictVariants_2 + ' }).ToDictionary(x=> x.Key, x=> x.Value)';
                }
                break;
            }
        }
        var formula = 'return new DropDownValue(' + variants + ',' + this.parentScope.param.Dropdown.canMultipleSelect + ', ' + defaultValue + ');';
        return formula;
    };
    DropdownSettingsCtrl.prototype.checkDuplication = function () {
        var lenght = this.variations.length;
        for (var i = 0; i < lenght - 1; i++) {
            for (var j = i + 1; j < lenght; j++) {
                if (this.variations[i].name === this.variations[j].name) {
                    return true;
                }
            }
        }
        return false;
    };
    DropdownSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Dropdown.canEdited();
    };
    DropdownSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Dropdown.canPlanned();
    };
    DropdownSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Dropdown.canBacklight();
    };
    DropdownSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Dropdown.canPredefined();
    };
    DropdownSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return !this.isCorrect;
    };
    DropdownSettingsCtrl.prototype.isSelectedOtherParameter = function () {
        return this.parentScope.param.Dropdown.defaultValueType === 1;
    };
    DropdownSettingsCtrl.prototype.add = function () {
        this.variations.push(new UiSelectItem('', ''));
    };
    DropdownSettingsCtrl.prototype.isManual = function () {
        return this.parentScope.param.Dropdown.source === 0;
    };
    DropdownSettingsCtrl.prototype.onChangeAdditionalVariants = function () {
        var oldCheckDuplicatesResult = this.isCorrect;
        this.isCorrect
            = _.unique(this.parentScope.param.Dropdown.dictionarySettings.additionalVariants).length
                === this.parentScope.param.Dropdown.dictionarySettings.additionalVariants.length;
        if (oldCheckDuplicatesResult != this.isCorrect && !this.isCorrect) {
            this.notificationService.errorMessage(this.language.getElementValue('reportParameterDropdownThereAreDuplicatesMsg'));
        }
    };
    DropdownSettingsCtrl.prototype.isDictionary = function () {
        return this.parentScope.param.Dropdown.source === 2;
    };
    DropdownSettingsCtrl.prototype.onDictionarySelected = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        this.updateClasses();
    };
    DropdownSettingsCtrl.prototype.updateParentInstances = function () {
        var _this = this;
        var filteredParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (i) {
            return i.Ident !== _this.parentScope.param.Ident && i.ParameterType === 'string';
        });
        this.parentInstances = _.map(filteredParameters, function (param) { return new UiSelectItem(param.Ident, param.Ident); });
    };
    DropdownSettingsCtrl.prototype.onSelectParentClassInstance = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    DropdownSettingsCtrl.prototype.updateClasses = function () {
        var _this = this;
        if (!this.parentScope.param.Dropdown.dictionarySettings || !this.parentScope.param.Dropdown.dictionarySettings.dictionaryUniqueCode) {
            return;
        }
        var dictionary = _.find(this.dictionary, function (dict) { return dict.Id == _this.parentScope.param.Dropdown.dictionarySettings.dictionaryUniqueCode; });
        if (!dictionary) {
            this.classes = [];
        }
        var classes = [];
        var getChildrenClasses = function (e) {
            classes.push(new UiSelectClassInfo(e.TargetUniqueCode, e.Name, _.isDefined(e.ParentId)));
            e.Items && e.Items.forEach(getChildrenClasses);
        };
        _.forEach(dictionary.Items, getChildrenClasses);
        this.classes = classes;
        _.find(this.classes, function (cl) { return true; });
        if (!_.find(classes, function (classInfo) { return classInfo.ident === _this.parentScope.param.Dropdown.dictionarySettings.classUniqueCode; })) {
            this.parentScope.param.Dropdown.dictionarySettings.classUniqueCode = null;
            this.parentScope.param.Dropdown.dictionarySettings.parentInstanceParameterIdent = null;
        }
    };
    DropdownSettingsCtrl.prototype.onSelectDictionaryClass = function (item) {
        if (!item.hasParent) {
            this.parentScope.param.Dropdown.dictionarySettings.parentInstanceParameterIdent = null;
        }
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    DropdownSettingsCtrl.prototype.classHasParent = function () {
        var _this = this;
        var currentClass = _.find(this.classes, function (c) { return c.ident === _this.parentScope.param.Dropdown.dictionarySettings.classUniqueCode; });
        return currentClass && currentClass.hasParent;
    };
    DropdownSettingsCtrl.prototype.isAnotherParameter = function () {
        return this.parentScope.param.Dropdown.source === 1;
    };
    return DropdownSettingsCtrl;
}());
