var OdbcSettingsCtrl = (function () {
    function OdbcSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.functions = [];
        this.connectionTypes = [9];
        this.watchFunctions = [];
    }
    OdbcSettingsCtrl.prototype.init = function () {
        var selfScope = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('tableHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('doubleArray', this.language.getElementValue('reportParameterDoubleArrayHdr'), 'double[][]'),
            new SelectSourceFunctionsItem('objectArray', this.language.getElementValue('reportParameterTypeTableObjectHdr'), 'object[][]'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
            new SelectSourceFunctionsItem('stringOneDimArray', this.language.getElementValue('sqlStringSetHdr'), 'string[]'),
        ], function (t) {
            return t.ident === selfScope.parentScope.param.Odbc.func;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            selfScope.parentScope.param.Odbc.func = after.ident;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return selfScope.parentScope.param.Odbc.sql;
        }, function (before, after) {
            if (_.isUndefined(selfScope.parentScope.param.Odbc) ||
                _.isNull(selfScope.parentScope.param.Odbc) ||
                after === before ||
                _.isUndefined(after))
                return;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return selfScope.parentScope.param.Odbc.includeHeader;
        }, function (before, after) {
            if (_.isUndefined(selfScope.parentScope.param.Odbc) ||
                _.isNull(selfScope.parentScope.param.Odbc) ||
                after === before ||
                _.isUndefined(after))
                return;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return selfScope.parentScope.param.Odbc.connectionGuid;
        }, function (http) {
            if (http == undefined)
                return;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        }));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    OdbcSettingsCtrl.prototype.getFormula = function () {
        var connectionGuid = this.parentScope.param.Odbc.connectionGuid;
        var sql = ReportFormulaEscaper.escape(this.parentScope.param.Odbc.sql, this.parentScope.reportTemplate.Parameters);
        switch (this.functions.selected.ident) {
            case 'table':
                return ('return OdbcTableByConnection("' +
                    connectionGuid +
                    '", ' +
                    sql +
                    ', ' +
                    this.parentScope.param.Odbc.includeHeader +
                    ');');
            case 'doubleArray':
                return 'return OdbcDoubleArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'objectArray':
                return 'return OdbcAsObjectArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'cellString':
                return 'return OdbcStringByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'cellDouble':
                return 'return OdbcDoubleByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'stringOneDimArray':
                return 'return OdbcStringArray("' + connectionGuid + '", ' + sql + ')[0];';
        }
        return '';
    };
    OdbcSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    OdbcSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Odbc.canEdited();
    };
    OdbcSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Odbc.canPlanned();
    };
    OdbcSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Odbc.canBacklight();
    };
    OdbcSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Odbc.canPredefined();
    };
    OdbcSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    return OdbcSettingsCtrl;
}());
