var PiramidaDiscreteSettings = (function () {
    function PiramidaDiscreteSettings(parentScope, language, discreteSettings) {
        var _this = this;
        if (!_.isNull(discreteSettings)) {
            this.discreteDefaultValue = discreteSettings.discreteDefaultValue;
            this.discreteGroupName = discreteSettings.discreteGroupName;
            this.discreteName = discreteSettings.discreteName;
        }
        this.discreteDefaultStates = getVariantsContainer(parentScope, [
            new UiSelectItem(0, language.getElementValue('piramidaDiscreteDefaultStateOffHdr')),
            new UiSelectItem(1, language.getElementValue('piramidaDiscreteDefaultStateOnHdr')),
        ], function (t) {
            return t.ident === _this.discreteDefaultValue;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            _this.discreteDefaultValue = after.ident;
        });
        this.destroy = function () {
            _this.discreteDefaultStates.destroy();
        };
    }
    PiramidaDiscreteSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = {
            discreteDefaultValue: obj.discreteDefaultValue,
            discreteGroupName: obj.discreteGroupName,
            discreteName: obj.discreteName,
        };
        return clone;
    };
    PiramidaDiscreteSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.discreteGroupName === other.discreteGroupName &&
            obj.discreteName === other.discreteName &&
            obj.discreteDefaultValue === other.discreteDefaultValue);
    };
    return PiramidaDiscreteSettings;
}());
