var FileExportAction = (function () {
    function FileExportAction(scope, source) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.type = 3;
        this.watchFunction = [];
        var self = this;
        if (source) {
            self.uploadDirectory = source.uploadDirectory;
            self.fileType = source.fileType;
            self.executionStatus = source.executionStatus;
            self.currentAttemps = source.currentAttemps;
        }
        else {
            self.uploadDirectory = '';
            self.fileType = 1;
            self.executionStatus = null;
            self.currentAttemps = 0;
        }
        self.exportFileTypes = getVariantsContainer(scope, [
            { name: 'PDF', ident: 1 },
            { name: 'Excel', ident: 0 },
            { name: 'HTML', ident: 2 },
            { name: 'Txt', ident: 3 },
            { name: 'Xml', ident: 4 },
            { name: 'Csv', ident: 5 },
        ], function (item) {
            return item.ident === self.fileType;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            self.fileType = after.ident;
        });
        self.watchFunction.push(scope.$on('$destroy', function () {
            _this.exportFileTypes.destroy();
            _.forEach(self.watchFunction, function (func) {
                if (!_.isUndefined(func)) {
                    func();
                }
            });
        }));
    }
    FileExportAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.fileType === other.fileType && obj.uploadDirectory === other.uploadDirectory;
    };
    return FileExportAction;
}());
